import re as regex
import typing

import numpy as np
import pandas as pd

_ac_extract_regex = regex.compile(r'(?<=\(AT-OBV\))(AC\d+)(?=;|$)')


def extract_ac_from_series_generator(series: pd.Series) -> typing.Generator[str, None, None]:
    for value in series:
        value = str(value)
        first = _ac_extract_regex.search(value)
        if first is None:
            continue  # raising error in loop is … bäh
        yield first.group(0)


def extract_ac_from_series(series: pd.Series) -> typing.List[str]:
    return [value for value in extract_ac_from_series_generator(series)]
