import httpx
import pandas as pd
import pytest

from travelogues_extraction.getrecords.session import RecordRetriever
from travelogues_extraction.getrecords.acnumber_extractor import extract_ac_from_series
from travelogues_extraction.dataextractors.dataextractors.index import IndexSetter, MMSID

dummy_data = pd.read_excel('test/dummy_data/TravelogueD19_ALMAoutput_20200712.xlsx')

@pytest.mark.asyncio
async def test_index_and_mmsid():
    reduced_series = dummy_data['Datensatznummer'][:25]
    session = httpx.AsyncClient()
    record_retriever = RecordRetriever(extract_ac_from_series(reduced_series), session=session)
    target_dataframe = pd.DataFrame([])
    index_setter = IndexSetter(target_dataframe)
    mmsid_extractor = MMSID(target_dataframe)

    record_generator = record_retriever.generate_records()

    record = await record_generator.__anext__()
    await index_setter.write(record)
    assert index_setter.target_dataframe.shape == (1, 1)
    assert index_setter.target_dataframe.iloc[0, 0].startswith('AC')
    await mmsid_extractor.write(record)
    assert mmsid_extractor.target_dataframe.shape == (1, 2)
    assert index_setter.target_dataframe.iloc[0, 1][0].isdigit()

    # once more in another style

    transformers = (index_setter, mmsid_extractor)
    index = 2

    async for record in record_generator:

        for column, transformer in enumerate(transformers):
            await transformer.write(record)
            assert target_dataframe.shape == (index, 2)
            assert target_dataframe.iat[index -1, column].__class__ is str

        index += 1
        if index == 5:
            break



