import pandas as pd

from travelogues_extraction.getrecords.acnumber_extractor import extract_ac_from_series

dummy_data = pd.read_excel('test/dummy_data/TravelogueD18_ALMAoutput_20200707.xlsx')

def test_acnumber_extractor():

    ac_list = [ac for ac in extract_ac_from_series(dummy_data['Datensatznummer'])]
    assert all([ac.__class__ is str for ac in ac_list])
    assert all([ac.startswith('AC') for ac in ac_list])