from lxml import etree as lxmletree

from travelogues_extraction.dataextractors.namespaces import namespaces
from travelogues_extraction.dataextractors.abstract import AbstractMultifield


class VerfasserGND(AbstractMultifield):

    column = 'Verfasser ; GND-ID'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="100"]', namespaces=namespaces)


    xpath_isgnd_tuples = (
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="a"]', namespaces=namespaces), isgnd=False),
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="c"]', namespaces=namespaces), isgnd=False),
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="0"]', namespaces=namespaces), isgnd=True),
    )


class ReihentitelBandzählung(AbstractMultifield):

    column = 'Reihentitel ; Bandzählung'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="490" and @ind1="1"]', namespaces=namespaces)

    xpath_isgnd_tuples = (
        VerfasserGND.xpath_isgnd_tuples[0],
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="v"]', namespaces=namespaces), isgnd=False)
    )


class HaupttitelTitelzusatzVerantwortlichkeitsangabe(AbstractMultifield):

    join_string_secondary_level = ' $ '

    column = 'Haupttitel ; Titelzusatz ; Verantwortlichkeitsangabe'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="245" and @ind2="0" and (@ind1="0" or @ind1="1")]', namespaces=namespaces)

    xpath_isgnd_tuples = (
        VerfasserGND.xpath_isgnd_tuples[0],
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="b"]', namespaces=namespaces), isgnd=False),
        VerfasserGND.xpath_isgnd_tuples[2],

    )

class BandzählungTitelDesBandes(AbstractMultifield):

    column = 'Bandzählung ; Titel des Bandes'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="245" and (@ind1="1" or @ind1="0") and @ind2="0"][1]', namespaces=namespaces)

    xpath_isgnd_tuples = (
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="n"]', namespaces=namespaces), isgnd=False),
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="p"]', namespaces=namespaces), isgnd=False),
    )


class VerlagsOrtNormiertGND(AbstractMultifield):

    column = 'Verlagsort normiert ; GND-ID'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="751"]', namespaces=namespaces)

    xpath_isgnd_tuples = (VerfasserGND.xpath_isgnd_tuples[0], VerfasserGND.xpath_isgnd_tuples[2])


class DruckOrtNormiertGND(AbstractMultifield):

    column = 'Druckort normiert ; GND-ID'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="751" and @ind1=" " and @ind2=" " and marc:subfield[@code="4" and text()="mfp"]]', namespaces=namespaces)

    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples


class VerlegerNormiertGNDID(AbstractMultifield):

    column = 'Verleger normiert ; GND-ID'

    primary_xml_path = lxmletree.XPath(
        (
            './'
            'marc:datafield['
                '('
                    '(@tag="700" and @ind1="1")'
                    ' or '
                    '(@tag="710" and @ind1="2")'
                ')'
                ' and marc:subfield[@code="4" and text()="pbl"]'
            ']'
         ), namespaces=namespaces)

    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples


class DruckerGNDID(AbstractMultifield):

    column = 'Drucker ; GND-ID'

    primary_xml_path = lxmletree.XPath(
        (
            './marc:datafield['
                '('
                    '(@tag="700" and @ind1="1")'
                    'or'
                    '(@tag="710" and @ind1="2" and @ind2=" ")'
                ')'
                'and'
                'marc:subfield[@code="4" and text()="prt"]'
            ']'
        ), namespaces=namespaces)

    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples


class WeitereVerfasserGNDID(AbstractMultifield):

    column = 'Weitere Verfasser ; GND-ID'

    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="700" and @ind1="1" and @ind2=" " and marc:subfield[@code="4" and text()="aut"]]', namespaces=namespaces)
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples


class HerausgeberGNDID(AbstractMultifield):

    column = 'Herausgeber ; GND-ID'
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples
    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="700" and @ind1="1" and @ind2=" " and marc:subfield[@code="4" and text()="edt"]]', namespaces=namespaces)


class ÜbersetzerGNDID(AbstractMultifield):
    column = 'Übersetzer ; GND-ID'
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples
    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="700" and @ind1="1" and @ind2=" " and marc:subfield[@code="4" and text()="trl"]]', namespaces=namespaces)


class BeiträgerGNDID(AbstractMultifield):
    column = 'Beiträger ; GND-ID'
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples
    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="700" and @ind1="1" and @ind2=" " and marc:subfield[@code="4" and text()="ctb"]]', namespaces=namespaces)


class WeitereBeteiligteGNDID(AbstractMultifield):
    column = 'Weitere Beteiligte ; GND-ID'
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples
    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="700" and @ind1="1" and @ind2=" " and marc:subfield[@code="4" and (text()="oth" or text()="com")]]', namespaces=namespaces)


class IllustratorenGNDID(AbstractMultifield):
    column = 'Illustratoren ; GND-ID'
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples
    primary_xml_path = lxmletree.XPath(
        (
            './marc:datafield['
                '((@tag="700" and @ind1="1") or (@tag="710" and @ind1="2"))'    
                    'and'
                'marc:subfield[@code="4" and (text()="egr" or text()="ill" or text()="ltg")]'
            ']'
        ), namespaces=namespaces)


class WidmenderGNDID(AbstractMultifield):
    column = 'Widmender ; GND-ID'
    xpath_isgnd_tuples = VerlagsOrtNormiertGND.xpath_isgnd_tuples
    primary_xml_path = lxmletree.XPath(
        (
            './marc:datafield['
                '((@tag="700" and @ind1="1") or (@tag="710" and @ind1="2") or (@tag="100" and @ind1="1" and @ind2=" "))'
                'and'
                'marc:subfield[@code="4" and text()="dto"]'
            ']'
        ), namespaces=namespaces)


class WidmungsempfängerGNDID(AbstractMultifield):
    column = 'Widmungsempfänger ; GND-ID'
    xpath_isgnd_tuples = (
        VerlagsOrtNormiertGND.xpath_isgnd_tuples[0],
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="c" and parent[@tag="700" and @ind1="0" and @ind2=" "]]', namespaces=namespaces), isgnd=False),
        VerlagsOrtNormiertGND.xpath_isgnd_tuples[1],
    )
    primary_xml_path = lxmletree.XPath(
        (
            './ marc:datafield['
                '((@tag="700" and @ind1="1") or (@tag="700" and @ind1="0" and @ind2=" ") or (@tag="710" and @ind1="2"))'
                'and'
                'marc:subfield[@code="4" and text()="dte"]'
            ']'
        ), namespaces=namespaces)


class WerkeInRelation(AbstractMultifield):
    column = 'Werke in Relation'
    primary_xml_path = lxmletree.XPath('./marc:datafield[(@tag="700" and @ind1="1" and @ind2="2") or (@tag="787" and @ind1="0" and @ind2="8")]', namespaces=namespaces)
    xpath_isgnd_tuples = (
        VerlagsOrtNormiertGND.xpath_isgnd_tuples[0],
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="t"]', namespaces=namespaces), isgnd=False),
        VerlagsOrtNormiertGND.xpath_isgnd_tuples[1],
    )


class Signatur(AbstractMultifield):
    column = 'Signatur'
    primary_xml_path = lxmletree.XPath('./marc:datafield[@tag="AVA" and @ind1=" " and @ind2=" "]', namespaces=namespaces)
    xpath_isgnd_tuples = (
        AbstractMultifield.XpathIsGnd(xpath=lxmletree.XPath('./marc:subfield[@code="d" or @code="i" or @code="j"]', namespaces=namespaces), isgnd=False),
    )