import typing

if typing.TYPE_CHECKING:
    from travelogues_extraction.getrecords.session import RecordRetriever

from lxml import etree as lxmletree

from travelogues_extraction.dataextractors.abstract import AbstractSingleDataExtractor, AbstractXpathDirectlyToColumn
from travelogues_extraction.dataextractors.namespaces import namespaces


class IndexSetter(AbstractSingleDataExtractor):
    """
    Column 1: Systemnummer
    """

    column: str = 'Systemnummer'

    async def write(self, record: 'RecordRetriever.Record') -> typing.Optional[str]:
        self.target_dataframe.at[record.ac_number, self.column] = record.ac_number
        return record.ac_number


class MMSID(AbstractXpathDirectlyToColumn):
    """
    Column 2: 'MMS-ID'
    """

    column: str = 'MMS-ID'
    xpath = lxmletree.XPath('./marc:controlfield[@tag="001"]', namespaces=namespaces)
