import asyncio
import datetime
import json
import os
import pathlib
import re as regex

import typing

from travelogues_extraction.controller.main import FromAlmaOutputToExcel

input_folder = './travelogues_extraction/script/input/'
output_folder = './travelogues_extraction/script/output/'
filter = 'D1'

files = os.listdir(input_folder)
files = [file for file in files if filter in file]
files = [input_folder + file for file in files]


async def extract(input_file: str, output_folder: str) -> typing.NoReturn:
    input_path = pathlib.Path(input_file)
    output_path = pathlib.Path(
        output_folder + \
        input_path.name.replace(
            'ALMAoutput', 'script_output_' \
                          + datetime.datetime.now().strftime("%Y-%m-%d_%H-%M-%S"))
    )

    converter = FromAlmaOutputToExcel(input_file, output_path.absolute(), slice(None, 2, 1))
    await converter.runasync()
    await converter.close()
    converter.write()
    match = regex.search(r'[dD]1\d', input_file)
    name = match.group(0) if match else 'VDXX'
    converter.log.to_csv('log-' + name + datetime.datetime.now().strftime("-%Y-%m-%d-%H:%M:%S") + '.csv')
    # to do unblock
    with open('sub-log-' + name + datetime.datetime.now().strftime("-%Y-%m-%d-%H:%M:%S") + '.json', 'w') as file:
        json.dump(converter.sub_log, file)

loop = asyncio.new_event_loop()
tasks = [loop.create_task(extract(file, output_folder)) for file in files]
waiter = asyncio.wait(tasks)
loop.run_until_complete(waiter)
