import pandas as pd

def compare(column: str, left: pd.DataFrame, right: pd.DataFrame) -> pd.DataFrame:
    left_column = left[column]
    right_column = right[column]
    old_diff = left_column[left_column != right_column]
    new_diff = right_column[left_column != right_column]
    return pd.DataFrame({
        'old_value': old_diff,
        'new_value': new_diff,
    }, index=old_diff.index)


