This Readme offers explanations for all attributes of the metadata csv table to the dataset "Die Bombe".
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the Relational Database (MySQL) used for ANNO.

| attribute | explanation | frequency | datatype |
| ---- | ---- | ---- | ---- |
| manifest_id | ID for the IIIF manifest in the form of \{aidaaaammdd} | all | string |
| aid | ID for issues contained in the ANNO database, usually an abbreviation for the title | all | string |
| year | year of publication | all | integer |
| day | date of publication | all | string |
| dc_title | title of the newspaper | all | string |
| dc_title_additional | subtitle or any other additional title of the resource | none | string |
| subjects | subject terms (German), not linked to authority file; multiple values are separated by a hyphen | all | string |
| place_of_publications | placename (German) of publication place, not linked to authority file | all | string |
| languages | language of the document in the form of ISO-639-1 | all | string |
| dc_type | type of the document (English); default is "newspaper" | all | string |
| meta_type | type of document (German); default is "zeitungen" | all | string |
| ini_type | value for database; default is "anno" | all | string |
| modification_datetime | timestamp for date of last modification of the database entry | all | datetime |
| longer_page_id | value is either "O" or "1" | all | integer |
| dc_date | date of publication in ISO-form "aaaa-mm-dd"| all | date |
| link_pdf | URL to PDF download of issue | all | string |
| link_old | URL to issue in the ANNO interface | all | string |
| has_ocr | value is "1" if the document has OCR, else value is "0" | all | integer |
| page_count | number of pages for each issue | all | integer |
