# Historical Postcards Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Historical Postcards.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
Please note that the CSV is an export of keys and values of the Relational Database Kawan used for editing the metadata. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| akon_id | id of the document; please refer to this id | all | string |AK111_169|
| id | internal numerical id | all | integer |74830|
| altitude | geolocation altitude | some | integer ||
| building | name of a building (human artifact) | some | string |Station Klamm|
| city | placename (city) | most | string |Klamm am Semmering|
| color | True for color postcards | all | boolean |FALSCH|
| comment | date or determined date; "date gel" stands for "date gelaufen", "gelaufen" means that year the postcards was sent, usually marked by a postal stamp; "v. date" stands for "vor …" (engl. before), means a date ante quem | most | string |1915 gel|
| mountain | name of mountain, not linked to authority file | some | string |Sonnwendstein |
| other | any other tags | some | string ||
| photographer | personal name or corporate name, not linked to authority file. Name usually in the form \{forename surname\}  | some | string ||
| publisher | personal name or corporate name, not linked to authority file. Name usually in the form \{forename surname\} OR \{surname\} | some | string ||
| publisher_place | placename, not linked to authority file (GND, Geonames) | some | string ||
| region |  | some | string ||
| water_body | name of a body of water, not linked to authority file (GND, Geonames) | some | string ||
| year | exact year the of the postcard, if it can be dated. If no exact date is available, a value can be found in the "comment" attribute | some | integer ||
| inventory_number | an internal inventory number usually in the form of \{number/number section\} | some | string ||
| signature | informations on attributions to former collections or subcollections; may contain information on provenance; please note the abbrevations | some | string |Geogr. Topogr. Bilder-Samml. 1944, 749|
| revision_date | timestamp of last revision of metadata in the RDB Kawan | most | date |05.09.2014  10:40:37|
| date | combination of year and comment, "gelaufen" and "vor" are usually not abbreviated in this field | most | string |gelaufen 1915|
| feature_class | code of the GeoNames export codes https://www.geonames.org/export/codes.html  | most | string |P|
| feature_code | code of the GeoNames export codes https://www.geonames.org/export/codes.html | most | string |PPL|
| geoname_id | GeoName identifier of placename (attribute: "name"), if a placename has been identified | most | float |27743160|
| latitude | geolocation latitude as provided by GeoNames | most | float |47660760000000000|
| longitude | geolocation longitude as provided by GeoNames | most | float |1586786|
| name | placename of place identified (GeoName ID is in attribute "geoname_id") | most | string |Klamm|
| country_id | code for country (modern) within which borders the identified placename lies today; the form is ISO-3166 Alpha-2 code | most | string |AT|
| admin_name_1 | | some | string |Niederösterreich|
| admin_code_1 | | some | string |03|
| geo | Tuple of latitude comma longitude | most | string |47.66076, 15.86786|
| download_link | url to the full resolution image | all | string |https://iiif.onb.ac.at/images/AKON/AK111_169/169/full/full/0/native.jpg|
| download_link_256x256 | url to the thumbnail image with resolution 256×256 px | all | string |https://iiif.onb.ac.at/images/AKON/AK111_169/169/full/256,256/0/native.jpg|
