This Readme offers explanations for all attributes of the metadata csv table to the dataset "Historical Postcards". 
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
Please note that the CSV is an export of keys and values of the Relational Database Kawan used for editing the metadata. Some values may have a false attribution. Some data cleaning may be necessary.

| attribute | explanation | frequency | datatype |
| ---- | ---- | ---- | ---- |
| akon_id | id of the document; please refer to this id | all | string |    
| id | internal numerical id | all | integer |
| altitude | geolocation altitude | some | integer |
| building | name of a building (human artifact) | some | string |
| city | placename (city) | most | string |
| color | True for color postcards | all | boolean |
| comment | date or determined date; "date gel" stands for "date gelaufen", "gelaufen" means that year the postcards was sent, usually marked by a postal stemp; "v. date" stands for "vor ..." (engl. before), means a date ante quem | most | string |   
| mountain | name of mountain, not linked to authority file | some | string |
| other | any other tags | some | string |
| photographer | personal name or corporate name, not linked to authority file. Name usually in the form \{forename surname\}  | some | string |
| publisher | personal name or corporate name, not linked to authority file. Name usually in the form \{forename surname\} OR \{surname\} | some | string |
| publisher_place | placename, not linked to authority file (GND, Geonames) | some | string |
| region |  | some | string |
| water_body | name of water_body, not linked to authority file (GND, Geonames) | some | string |
| year | exact year the postcard can be dated. If no exact date is available, a value can be found for the "comment" attribute | some | integer |
| inventory_number | an internal inventory number usually in the form of \{number/number section\} | some | string |
| signature | informations on attributions to former collections or subcollections; may contain information on provenance; please note the abbrevations | some | string |
| revision_date | timestamp of last revision of metadata in the RDB Kawan | most | date |
| date | combination of year and comment, "gelaufen" and "vor" are usually not abbreviated in this field | most | string |
| feature_class | code of the GeoNames export codes https://www.geonames.org/export/codes.html  | most | string |
| feature_code | code of the GeoNames export codes https://www.geonames.org/export/codes.html | most | string |
| geoname_id | GeoName identifier of placename (attribute: "name"), if a placename has been identified | most | float |
| latitude | geolocation latitude as provided by GeoNames | most | float |
| longitude | geolocation longitude as provided by GeoNames | most | float |
| name | placename of place identified (GeoName ID is in attribute "geoname_id") | most | string |
| country_id | code for country (modern) within which borders the identified placename lies today; the form is ISO-3166 Alpha-2 code | most | string |
| admin_name_1 | | some | string |
| admin_code_1 | | some | string |
| geo |  Tuple of latitude comma longitude | most | string |
| download_link | url to the full resolution image | all | string |
| download_link_256x256 | url to the thumbnail image with resolution 256x256 px | all | string |
