# Pamphlets 1848 Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Pamphlets 1848.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| mms_id | ID of the data record in the integrated library system ALMA (ExLibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |990049639970603000|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form "+Z\d{7}[0-9, A-Z]{1,2}" or a "dummy-barcode" in the form of "alma\d{6}" | most | string |+Z171377009|
| signature | shelfmark of document in collection of the Austrian National Library | most | string |F 015703-B|
| location | code for collection department at the Austrian National Library; "ALT FLUG" stands for the Pamphlet Collection of the Collection of Manuscripts and Rare Books | all | string |ALT FLUG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | none | string ||
| volumeNumber | number of volume as part of a multivolumed resource | some | string ||
| languages | code for language of the document in ISO-639 3 | most | string |ger|
| main_title | title of the document, either as in the resource or a fictitious title | most | string |Besondere Beilage zur Wiener Zeitung|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle  | most | string ||
| related_title | any other title related to the document | most | string |Besondere Beilage zum Abendblatte der Wiener Zeitung|
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | most | string |XA-AT, XA-AAAT|
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form {surname, forename} OR {surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German | some | string |Jebmayer, Johann, 1770-1858 [MalerIn]|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | some | string ||
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file | most | string |[Wien]|
| yearOfPublication | year of creation of the papyrus | all | string |1848|
| dateOfPublication | | none | integer ||
| Subjects | subject terms in German | some | string |Österreich, Revolution, Quelle, Wien|
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | some | string |http://d-nb.info/gnd/4043271-3, http://d-nb.info/gnd/4049688-0, http://d-nb.info/gnd/4066009-6|
| gndReferences | | none | string ||
| classifications | classifications of the pamphlets | all | string |BASISKLASSIFIKATION: 15.36|
| contentInformations | description of the document | most | string ||
| physicalPages | number of pages; for this dataset every item is one page | most | string ||
| illustrations | information about the illustrations | some | string ||
| physicalFormat | dimensions of the leaves in centimeter | most | string ||
| sequence | NA | none | string ||
| urls | URL to entry in ÖNB Digital  | most | string |http://data.onb.ac.at/dtl/6918788, http://data.onb.ac.at/dtl/6918018, http://data.onb.ac.at/dtl/6918179, http://data.onb.ac.at/dtl/6918279|
| idnr |  ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPAC) | all | string |AC13364354|
