# Musical Manuscripts Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Musical Manuscripts.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| manifest_id | ID in the Austrian National Library’s digital repository, which is the document ID for the access link as well as the IIIF manifest; for this dataset "\d{7}"| all | string |3742255|
| mms_id | ID of the data record in the integrated library system ALMA (ExLibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | most | string |990052331610603000|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form "+Z\d{7}[0-9, A-Z]{1,2}" or a "dummy-barcode" in the form of "alma\d{6}" | all | string |+Z95055702|
| signature | shelfmark of document in collection of the Austrian National Library | most | string |Mus.Hs.40993|
| location | code for collection department at the Austrian National Library; "ALT FLUG" stands for the Pamphlet Collection of the Collection of Manuscripts and Rare Books | most | string |MUS MAG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | none | string ||
| volumeNumber | number of volume as part of a multivolumed resource | some | string ||
| languages | code for language of the document in ISO-639 3 | some | string |ger|
| main_title | title of the document, either as in the resource or a fictitious title | all | string |[D 219. Das Finden. D 227. Idens Nachtgesang.]|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle  | some | string |[Lieder für eine Singstimme und Klavier nach Gedichten von Ludwig Theobul Kosegarten.]|
| related_title | any other title related to the document | some | string |[Überschriftstitel Recto:] Das Finden. Kosegarten. [Verso:] Idens Nachtgesang. Kosegarten.|
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | none | string ||
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form {surname, forename} OR {surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German | most | string |Schubert, Franz, 1797-1828, Kosegarten, Ludwig Gotthard,, 1758-1818, Schubert, Franz, 1797-1828, Schubert, Franz, 1797-1828|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | some | string ||
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file | some | string ||
| yearOfPublication | year of creation of the papyrus | most | string |comp. 25/6 1815; comp. 7/7 815|
| dateOfPublication | | none | integer ||
| Subjects | subject terms in German | some | string |Vokalmusik, Solo, Musikhandschrift|
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | some | string |http://d-nb.info/gnd/4063783-9, http://d-nb.info/gnd/4313218-2|
| gndReferences | | some | string ||
| classifications | classifications of the musical manuscripts | none | string ||
| contentInformations | description of the document | most | string |Autograph (Reinschrift), 1 Bl. (loses Einzelblatt), Recto, rechts: "Nachlaß No 42/ 8819 / comp. 25/6 1815 laut Repertorium" [teilw. od. ganz? fremde Hand]. "Singst./ Piano-/forte." Li unten auf beiden Seiten Zählung: "5" bzw. "6". Li oben dgl. mit Rotstift "45" u. "46". Verso, rechts: "comp. 7/7 815 laut Repertorium". [Fremde Hand.]|
| physicalPages | number of pages; for this dataset every item is one page | most | string |Autograph (Reinschrift), 1 Bl. (loses Einzelblatt)|
| illustrations | information about the illustrations | some | string ||
| physicalFormat | dimensions of the leaves in centimeter | most | string |30,2 x 23 cm (Querformat)|
| sequence | NA | none | string ||
| urls | URL to entry in ÖNB Digital  | most | string |http://www.schubert-online.at/index_einzelansicht.php?werke_id=10005, http://www.schubert-online.at/index_einzelansicht.php?werke_id=10006, http://data.onb.ac.at/dtl/3742255|
| idnr |  ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPAC) | all | string |AC13909137|
