# Johann Caspar Lavater Collection Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Johann Caspar Lavater Collection.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| mms_id | ID of the data record in the integrated library system ALMA (ExLibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |9959026222303340|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form \"\+Z\d{7}[0-9, A-Z]{1,2}" | all | string |alma1489939|
| signature | shelfmark of document in collection of the Austrian National Library | all | string |LAV 50/784|
| location | code for collection department at the Austrian National Library | some | string |POR MAG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | none | string ||
| volumeNumber | number of volume as part of a multivolumed resource | none | string ||
| languages | code for language of the document in ISO-639 3  | some | string ||
| main_title | title of the document, either as in the resource or a fictitious title | all | string |Fugger von Kirchberg und zu Weißenhorn, Johann Georg Freiherr|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle | some | string ||
| related_title | any other title related to the document | none | string ||
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | some | string ||
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form \{surname, forename} OR \{surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]\}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German, "VerfasserIn" stands for "creator", "KomponistIn" for "composer" and "AdressatIn" for "adressee" | all | string |Custos, Dominicus, 1560-1615 [StecherIn], Fugger, Johann Georg, 1566-1585 [Abgebildet], Lavater, Johann Caspar, 1741-1801 [SammlerIn]|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | none | string ||
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file; "Ohne Ort" stands for "no placename known"; Cave: Those entries that do not have a value do not necessarily have no place of publication | some | string |Augsburg|
| yearOfPublication | either a year, a range of years separated by a hyphen or "[ohne Datumsangabe]" for documents without date | some | string |1618|
| yearOfPublication | either a year, a range of years separated by a hyphen or "[ohne Datumsangabe]" for documents without date | some | string |1618|
| dateOfPublication | year of publication in integer format | none | integer |1618|
| Subjects | subject terms in German as used in the RSWK (Regeln fÃ¼r Schlagwortkatalogisierung), usually in the form of the GND authority file; the subject term can also be a term for a document type (e.g. "Lebensdokument"); Please note that the subject terms are not fully consistent within the dataset | most | string |Physiognomik, Grafik|
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | most | string |https://d-nb.info/gnd/4076122-8, https://d-nb.info/gnd/4021845-4|
| gndReferences | | some | string |[{'gndNr': 'https://d-nb.info/gnd/122235800', 'references': ['Baltens, Dominik', 'Coster, Dominicus', 'Coster, Dominique de', 'Custodis, Dominicus', 'Custos, Dominic', 'Custos, Dominicus', 'Custos, Dominik', 'D C', 'D. C.']}, {'gndNr': 'https://d-nb.info/gnd/4076122-8', 'references': ['Antlitzdiagnostik', 'Gesichtsdiagnostik', 'Physiognomik', 'Physiognomische Diagnostik']}, {'gndNr': 'https://d-nb.info/gnd/4021845-4', 'references': ['Grafik', 'Graphik']}, {'gndNr': 'https://d-nb.info/gnd/1011714051', 'references': ['Fugger von Kirchberg und zu Weissenhorn, Johann Georg', 'Fugger von Kirchberg und zu Weißenhorn, Johann Georg', 'Fugger, Ioannes Georgius', 'Fugger, Joanes Georgius', 'Fugger, Johann Georg', 'Fvgger, Ioannes Georgivs', 'Kirchberg und zu Weissenhorn, Johann Georg Fugger von', 'Kirchberg und zu Weißenhorn, Johann Georg Fugger von', 'Weissenhorn, Johann Georg Fugger von Kirchberg und zu', 'Weißenhorn, Johann Georg Fugger von Kirchberg und zu']}, {'gndNr': 'https://d-nb.info/gnd/118570293', 'references': ['Asahel, Jonathan', 'Einsiedler vom Berg', 'Lafater', 'Lafater, Gaspard', 'Lafater, Iogan K.', 'Lafater, Iogann Kaspar', 'Lavater', 'Lavater, Caspar', 'Lavater, Gaspar', 'Lavater, Gaspard', 'Lavater, Hans C.', 'Lavater, Hans Caspar', 'Lavater, Hans Kaspar', 'Lavater, Iohann K.', 'Lavater, J. C.', 'Lavater, J. K.', 'Lavater, Jean Caspar', 'Lavater, Jean G.', 'Lavater, Jean Gaspard', 'Lavater, Jean-Gaspard', 'Lavater, Joh. Caspar', 'Lavater, Johann C.', 'Lavater, Johann Caspar', 'Lavater, Johann Casper', 'Lavater, Johann K.', 'Lavater, Johann Kaspar', 'Lavater, Johann Kasper', 'Lavater, Johannes Caspar', 'Lavater, Johannes Kaspar', 'Lavater, John C.', 'Lavater, John Caspar', 'Lavater, Kaspar', 'Lavater-Schinz, Johann Caspar', 'Lavaterus', 'Lavaterus, I. C.', 'Lavaterus, Ioannes Casparus', 'Lavaterus, Joannes Casparus', 'Lavaterus, Johannes C.', 'Lavaterus, Johannes Casparus', 'Lawater, Johann Caspar', 'Natalion, a Sacra Rupe', 'Nathalion, a Sacra Rupe', 'Nathalion, a Sacra Rvpe', 'Schinz, Johann Caspar Lavater-']}]|
| classifications | NA | none | string ||
| contentInformations | any information on the content of the document, e.g. if illustrated or the coverage | most | string |Blatt in Original-Montierung, Die historischen Beschreibungen und Abbildungen können rassistische, sexistische oder andere ethisch problematische und verletzende Bewertungen enthalten. Die Österreichische Nationalbibliothek stellt die Inhalte für Forschungszwecke zur Verfügung und distanziert sich ausdrücklich von diesen.|
| physicalPages | any information on the coverage of the document (Umfang); The value may be identical to the value in "contentInformations" | most | string |1 Druckgrafik|
| illustrations | information on the illustrations; please refer to the attribute "contentInformations" | none | string ||
| physicalFormat | size of the document either in centimeters (width per height) or in sheet format (8Â° for Octavo, 4Â° for Quarto) | some | string ||
| sequence | link to sequential documents | none | string ||
| urls | sequence of URLs; "https://data.onb.ac.at/rep*" for the entry in Ã–NB Digital, "http://katzoom.onb.ac.at*" for images of the card catalogue entries, and others | all | string |https://data.onb.ac.at/rep/131D88BF|
| idnr | ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPA) | all | string |GZ01295041|
| manifest_id | ID in the Austrian National Library’s digital repository, which is the document ID for the access link as well as the IIIF manifest | all | string |131D88BF|
