# Jesuit Chronicles Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Jesuit Chronicles.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| mms_id | ID of the data record in the integrated library system ALMA (Exlibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |990052723230603000|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form \"\+Z\d{7}[0-9, A-Z]{1,2}" | all | string |+Z15212260X|
| signature | shelfmark of document in collection of the Austrian National Library | all | string |Cod. 11981|
| location | code for collection department at the Austrian National Library | some | string |HAN MAG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | none | string ||
| volumeNumber | number of volume as part of a multivolumed resource | none | string ||
| languages | code for language of the document in ISO-639 3  | some | string |lat|
| main_title | title of the document, either as in the resource or a fictitious title | all | string |Syntagma iuris universi Societatis Iesu|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle | some | string ||
| related_title | any other title related to the document | none | string ||
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | some | string ||
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form \{surname, forename} OR \{surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]\}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German, "VerfasserIn" stands for "creator", "KomponistIn" for "composer" and "AdressatIn" for "adressee" | all | string |Mangioni, Valentino, 1573-1660 [VerfasserIn]|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | none | string ||
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file; "Ohne Ort" stands for "no placename known"; Cave: Those entries that do not have a value do not necessarily have no place of publication | some | string ||
| yearOfPublication | either a year, a range of years separated by a hyphen or "[ohne Datumsangabe]" for documents without date | some | string |1652-1699|
| dateOfPublication | year of publication in integer format | none | integer ||
| Subjects | subject terms in German as used in the RSWK (Regeln fÃ¼r Schlagwortkatalogisierung), usually in the form of the GND authority file; the subject term can also be a term for a document type (e.g. "Lebensdokument"); Please note that the subject terms are not fully consistent within the dataset | most | string ||
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | most | string ||
| gndReferences | | some | string |[{'gndNr': 'https://d-nb.info/gnd/131684345', 'references': ['Mangioni, Valentino', 'Mangioni, Valentinus', 'Mangionio, Valentino', 'Mangionius, Valentinus']}]|
| classifications | NA | none | string ||
| contentInformations | any information on the content of the document, e.g. if illustrated or the coverage | most | string |Angaben zum Inhalt von Tabulae codicum übernommen., Pergament über Pappdeckeln, Pergament über Papdeckeln.|
| physicalPages | any information on the coverage of the document (Umfang); The value may be identical to the value in "contentInformations" | most | string |Handschrift; III, 121 Bl; Moderne Foliierung;|
| illustrations | information on the illustrations; please refer to the attribute "contentInformations" | none | string ||
| physicalFormat | size of the document either in centimeters (width per height) or in sheet format (8Â° for Octavo, 4Â° for Quarto) | some | string |294 × 198 mm.|
| sequence | link to sequential documents | none | string ||
| urls | sequence of URLs; "https://data.onb.ac.at/rep*" for the entry in Ã–NB Digital, "http://katzoom.onb.ac.at*" for images of the card catalogue entries, and others | all | string |http://www.onb.ac.at/sammlungen/hschrift/bibliographie.htm, http://www.manuscripta-mediaevalia.de/hs/katalogseiten/HSK0751g_b0079_jpg.htm, https://data.onb.ac.at/rep/131F8C8A|
| idnr | ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPA) | all | string |AC13948298|
| manifest_id | ID in the Austrian National Library’s digital repository, which is the document ID for the access link as well as the IIIF manifest | all | string |131F8C8A|
