# Planned Languages Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Planned Languages.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| manifest_id | ID in the Austrian National Library’s digital repository, which is the document ID for the access link as well as the IIIF manifest; for this dataset "\d{7}"| all | string |6600051|
| mms_id | ID of the data record in the integrated library system ALMA (ExLibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |990005122330603000|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form "+Z\d{7}[0-9, A-Z]{1,2}" or a "dummy-barcode" in the form of "alma\d{6}" | all | string |+Z65245606|
| signature | shelfmark of document in collection of the Austrian National Library | most | string |701820-C-D|
| location | code for collection department at the Austrian National Library; "ALT FLUG" stands for the Pamphlet Collection of the Collection of Manuscripts and Rare Books | all | string |ESP MAG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | some | string |1163-0442|
| volumeNumber | number of volume as part of a multivolumed resource | some | string ||
| languages | code for language of the document in ISO-639 3 | most | string |epo|
| main_title | title of the document, either as in the resource or a fictitious title | all | string |Sennaciulo|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle  | most | string |oficiala organo de Sennacieca Asocio Tutmonda|
| related_title | any other title related to the document | some | string ||
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | most | string |XA-FR|
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form {surname, forename} OR {surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German | most | string |Barthelmess, Norbert, 1897-1987, Lanti, Eugène, 1879-1947, Vels, Bas, Barkovi?, Krešimir, Schram, Jakvo, Beto, Robin, Sanz, Pedro|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | most | string |Sennacieca Asocio Tutmonda|
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file | most | string |Paris|
| yearOfPublication | year of creation of the document | most | string |1925-|
| dateOfPublication | | none | integer ||
| Subjects | subject terms in German | most | string |dokumento Esperanta, Esperanto|
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | some | string |http://d-nb.info/gnd/4063783-9, http://d-nb.info/gnd/4313218-2|
| gndReferences | references to the GND (Gemeinsame Normdatei, “common authority file”) | some | string ||
| classifications | classifications of the documents | some | string |BASISKLASSIFIKATION: 18.97, REGENSBURGER_VERBUNDKLASSIFIKATION: 680|
| contentInformations | description of the document | some
 | string |Red.: Norbert Barthelmess: 1924-1925, 1928-1939, 1948-1982 ; Ivan Krestanov: 1926 ; Lanti: 1926 - 1928 ; Bas Vels: 1939 - 1948 ; Lucien Bannier: 1946 - 1948 ; Kre?imir Barkovi?: 1983 - 2006, 2007 - 2008 ; Cirilo Orsinger: 2007 ; Jakvo Schram: 2008 - 2011 ; Robin Beto: 2011 - 2014|
| physicalPages | number of pages or description of quantity of material | most | string ||
| illustrations | information about the illustrations | some | string ||
| physicalFormat | dimensions of the leaves in centimeter | some | string ||
| sequence | NA | none | string ||
| urls | URL to entry in ÖNB Digital  | most | string |http://data.onb.ac.at/dtl/6595561, http://data.onb.ac.at/dtl/6599739, http://data.onb.ac.at/dtl/6600051, http://data.onb.ac.at/dtl/6601933, http://data.onb.ac.at/dtl/6552673, http://data.onb.ac.at/dtl/6551030, http://data.onb.ac.at/dtl/6713494, http://data.onb.ac.at/dtl/6722220|
| idnr |  ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPAC) | all | string |AC02709315|
