# Die Bombe Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Die Bombe.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the Relational Database (MySQL) used for ANNO (AustriaN Newspapers Online). The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| manifest_id | ID for the IIIF manifest in the form of \{aidaaaammdd\} | all | string |bom18720915|
| aid | ID for issues contained in the ANNO database, usually an abbreviation for the title | all | string |bom|
| year | year of publication | all | integer |1872|
| day | date of publication in the form of \{aaaammdd\} | all | string |18720915|
| dc_title | title of the newspaper | all | string |Die Bombe|
| dc_title_additional | subtitle or any other additional title of the resource | none | string ||
| subjects | subject terms (German), not linked to authority file; multiple values are separated by a hyphen | all | string |Humor; Satire|
| place_of_publications | placename (German) of publication place, not linked to authority file | all | string |Wien|
| languages | language of the document in the form of ISO-639-1 | all | string |de|
| dc_type | type of the document (English); default is "newspaper" | all | string |newspaper|
| meta_type | type of document (German); default is "zeitungen" | all | string |zeitungen|
| ini_type | value for database; default is "anno" | all | string |anno|
| modification_datetime | timestamp for date of last modification of the database entry | all | datetime |26.09.2011  10:38:48|
| longer_page_id | value is either "O" or "1" | all | integer |0|
| dc_date | date of publication in ISO-form "aaaa-mm-dd"| all | date |1872-09-15|
| link_pdf | URL to PDF download of issue | all | string |http://anno.onb.ac.at/cgi-content/anno_pdf.pl?aid=bom&datum=18720915|
| link_old | URL to issue in the ANNO interface | all | string |http://anno.onb.ac.at/cgi-content/anno?aid=bom&datum=18720915|
| has_ocr | value is "1" if the document has OCR, else value is "0" | all | integer |1|
| page_count | number of pages for each issue | all | integer |12|
