# Botanical Illustrations Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Botanical Illustrations.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| manifest_id | ID in the Austrian National Library’s digital repository, which is the document ID for the access link as well as the IIIF manifest; for this dataset "BAG_\d{8}"| all | string |BAG_19226492|
| mms_id | ID of the data record in the integrated library system ALMA (ExLibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |9958694580903340|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form "+Z\d{7}[0-9, A-Z]{1,2}" or a "dummy-barcode" in the form of "alma\d{6}" | some | string ||
| signature | shelfmark of document in collection of the Austrian National Library, for this collection either "PK 507, ddd" or "PK 508, ddd" | all | string |Pk 507, 144|
| location | code for collection department at the Austrian National Library; "POR MAG" stands for the Portrait Collection of the Image Department | all | string |POR MAG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | none | string ||
| volumeNumber | number of volume as part of a multivolumed resource | none | string ||
| languages | code for language of the document in ISO-639 3 | none | string ||
| main_title | title of the document, either as in the resource or a fictitious title | all | string |Crinum augustum|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle  | none | string ||
| related_title | any other title related to the document | none | string ||
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | none | string ||
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form {surname, forename} OR {surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German, "MalerIn" stands for "Painter" | all | string |Jebmayer, Johann, 1770-1858 [MalerIn]|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | none | string ||
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file; "Ohne Ort" stands for "no placename known"; Cave: Those entries that do not have a value do not necessarily have no place of publication | none | string ||
| yearOfPublication | year of creation of the artwork | all | integer |1829|
| dateOfPublication | year of creation of the artwork, identical to "yearOfPublication" | all | integer |1829|
| Subjects | subject terms in German as used in the RSWK (Regeln für Schlagwortkatalogisierung), usually in the form of the GND authority file; the subject term can also be a term for a document type (e.g. "Pflanzen"); Please note that the subject terms are not fully consistent within the dataset | most | string |Botanik, Pflanzen, Pflanzen|
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | most | string ||
| gndReferences | | some | string ||
| classifications | NA | some | string ||
| contentInformations | physical description of the document | all | string |Aquarell über Bleistift von Johann Jebmayer für das „Florilegium B“ des Kaisers Franz I. von Österreich. Die dargestellte Pflanze blühte 1829 im k. k. Hofgarten in der Ungargasse (Kaisergarten oder Reservegarten auf der Landstraße), welcher 1837 aufgelöst wurde und sich auf dem Gebiet der heutigen Ungargasse, Boerhaavegasse und Juchgasse im 3. Wiener Gemeindebezirk befand.|
| physicalPages | number of pages; for this dataset every item is one page | none | string ||
| illustrations | information about the illustrations; for this dataset the number of illustration per page is one | none | string ||
| physicalFormat | dimensions of the leaves in centimeter | most | string |Blattmaß: Höhe: 53 cm - Breite: 37 cm|
| sequence | NA | none | string ||
| urls | URL to entry in ÖNB Digital  | all | string |https://data.onb.ac.at/rep/BAG_19226492|
| idnr |  ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPAC); in the form of "\{GZ\d{8}\}" where "G" stands for "Gideon", the database the data was migrated from into the library system ALMA | all | string |GZ00590085|
