This Readme offers explanations for all attributes of the metadata csv table to the dataset "Historical Postcards"

| attribute | explanation | frequency | datatype |
| ---- | ---- | ---- | ---- |
| akon_id | id (shelfmark) of the document | all | string |    
| id | internal numerical id | all | integer |
| altitude | geolocation altitude | some | integer |
| building | has literal, if building was tagged in metadata editing | some | string |
| city | has literal, if city was tagged in metadata editing | most | string |
| color | True for color postcards | all | boolean |
| comment | has literal for | most |     
| mountain | has literal, if mountain was tagged in metadata editing | some | string |
| other | has literal for any other tags | some | string |
| photographer | has literal, if photographer was identified. Name usually in the form \{forename surname\}. Not linked to GND | some | string |
| publisher | has literal, if publisher was identified. Name usually in the form \{forename surname\} OR \{surname\}. Not linked to GND | some | string |
| publisher_place | has literal, if publication place was identified. Not linked to Geonames or GND | some | string |
| region | | some | string |
| water_body | | some | string |
| year | | some | string |
| inventory_number | | some | string |
| signature | | some | string |
| revision_date | | some | string |
| date | | some | string |
| feature_class | | some | string |
| feature_code | | some | string |
| geoname_id | | some | string |
| latitude | | some | string |
| longitude | | some | string |
| name | | some | string |
| country_id | | some | string |
| admin_name_1 | | some | string |
| admin_code_1 | | some | string |
| geo | | some | string |
| download_link | url to the full resolution image | all | string |
| download_link_256x256 | url to the thumbnail image with resolution 256x256 px | all | string |