This Readme offers explanations for all attributes of the metadata csv table to the dataset "Historical Postcards".
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of catalogue system. Some values may have a false attribution. Some data cleaning may be necessary.      


| attribute | explanation | frequency | datatype |
| ---- | ---- | ---- | ---- |
| manifest_id | ID in the Austrian National Library's digital repository, which is the document ID for the access link as well as the IIIF manifest | all | string |
| mms_id | ID of the data record in the integrated library system ALMA (Exlibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form \"\+Z\d{7}[0-9, A-Z]{1,2}" | all | string |
| signature | shelfmark of document in collection of the Austrian National Library, for documents of the estate Alban Berg "F21.Berg.*"| all | string |
| location | code for collection department at the Austrian National Library; "MUS MAG" stands for the Music Department | some | string |
| urns | ID in the form of a Uniform Resource Name | none | string |
| snISBN | International Standard Book Number | none | string |
| snISSN | International Standard Serial Number | none | string |
| volumeNumber | number of volume as part of a multivolumed resource | none | string |
| languages | code for language of the document in ISO-639 3  | some | string |
| main_title | title of the document, either as in the resource or a fictious title | all | string |
| sub_title | subtitle of the document, either as in the resource or a fictious subtitle | some | string |
| related_title | any other title related to the document | none | string |
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | some | string |
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form \{surname, forename} OR \{surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]\}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German, "VerfasserIn" stands for "creator", "KomponistIn" for "composer" and "AdressatIn" for "adressee" | all | string |
| corperations | personal name of corperation involved | none | string |
| publishers | personal name of publisher if known | none | string |
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file; "Ohne Ort" stands for "no placename known"; Cave: Those entries that do not have a value do not necessarely have no place of publication | some | string |
| yearOfPublication | either a year, a range of years separated by a hyphen or "[ohne Datumsangabe]" for documents without date | some | string |
| dateOfPublication | year of publication in integer format | none | integer |
| Subjects | subject terms in German as used in the RSWK (Regeln für Schlagwortkatalogisierung), usually in the form of the GND authority file; the subject term can also be a term for a document type (e.g. "Lebensdokument"); Please note that the subject terms are not fully consistent within the dataset | most | string |
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | most | string |
| gndReferences | | some | string |
| classifications | NA | none | string |
| contentInformations | any information on the content of the document, e.g. if illustrated or the coverage | most | string |
| physicalPages | any information on the coverage of the document (Umfang); The value may be identical to the value in "contentInformations" | most | string |
| illustrations | information on the illustrations; please refer to the attribute "contentInformations" | none | string |
| physicalFormat | size of the document either in centimeters (width per height) or in sheet format (8° for Octavo, 4° for Quarto) | some | string |
| sequence | link to sequential documents | none | string |
| urls | sequence of URLs; "http://katzoom.onb.ac.at*" for images of the card catalogue entries, "http://data.onb.ac.at/mus*" for a former catalogue entry created at the Music Sammlung, "https://data.onb.ac.at/rep*" for the entry in ÖNB Digital | all | string |
| idnr | ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPA) | all | string |
