# Papyri Metadata Readme

This Readme offers explanations for all attributes of the metadata ``.csv`` table to the dataset “Papyri.”
The frequency attribute can have the value "all", "most", "some" or "none". It gives you an overview of how often a value is to be expected for the attribute explained in relation to the whole dataset.
The CSV is an export of keys and values of the ONB catalogue system. Some values may have a false attribution. Some data cleaning may be necessary. The exemplary data instance was taken from the full metadata ``.csv`` table.

| attribute | explanation | frequency | datatype | exemplary data instance |
| ---- | ---- | ---- | ---- | ---- |
| manifest_id | ID in the Austrian National Library’s digital repository, which is the document ID for the access link as well as the IIIF manifest; for this dataset "\d{7}"| all | string |7477429|
| mms_id | ID of the data record in the integrated library system ALMA (ExLibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |9958490000000000|
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form "+Z\d{7}[0-9, A-Z]{1,2}" or a "dummy-barcode" in the form of "alma\d{6}" | most | string |+Z194671105|
| signature | shelfmark of document in collection of the Austrian National Library | most | string |G 30308|
| location | code for collection department at the Austrian National Library; "PAP MAG" stands for the Papyrus Collection of the Papyrus Museum | all | string |PAP MAG|
| urns | ID in the form of a Uniform Resource Name | none | string ||
| snISBN | International Standard Book Number | none | string ||
| snISSN | International Standard Serial Number | none | string ||
| volumeNumber | number of volume as part of a multivolumed resource | none | string ||
| languages | code for language of the document in ISO-639 3 | most | string |grc|
| main_title | title of the document, either as in the resource or a fictitious title | most | string |Brief, Vertrag oder Testament (?), unpubliziert (P.Vindob. G 30308)|
| sub_title | subtitle of the document, either as in the resource or a fictitious subtitle  | some | string ||
| related_title | any other title related to the document | some | string ||
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | none | string ||
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form {surname, forename} OR {surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German | some | string |Jebmayer, Johann, 1770-1858 [MalerIn]|
| corperations | personal name of corporation involved | none | string ||
| publishers | personal name of publisher if known | some | string ||
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file | most | string |Ägypten|
| yearOfPublication | year of creation of the papyrus | most | string |6.-7. Jh.|
| dateOfPublication | | none | integer ||
| Subjects | subject terms in German | some | string ||
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | none | string ||
| gndReferences | | none | string ||
| classifications | NA | none | string ||
| contentInformations | description of the document | most | string |Mellon-Projekt (S. Tost, 2018)|
| physicalPages | number of pages; for this dataset every item is one page | most | string |1 Fragment|
| illustrations | information about the illustrations | none | string ||
| physicalFormat | dimensions of the leaves in centimeter | all | string |ca. 6 x 8 cm|
| sequence | NA | none | string ||
| urls | URL to entry in ÖNB Digital  | most | string ||
| idnr |  ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPAC) | most | string ||
