This Readme offers explanations for all attributes of the metadata csv table to the dataset "Botanical Illustrations"

| attribute | explanation | frequency | datatype |
| ---- | ---- | ---- | ---- |
| manifest_id | ID in the Austrian National Library's digital repository, which is the document ID for the access link as well as the IIIF manifest; for this dataset "BAG_\d{8}"| all | string |
| mms_id | ID of the data record in the integrated library system ALMA (Exlibris group); The ID is the identifier of the local data record (local zone); The MMS-ID may be a value needed for a SRU request | all | string |
| barcode | ID of the document; At the Austrian National Library every digitized document in this collection has a barcode as identifier for the digitized item, usually in the form "+Z\d{7}[0-9, A-Z]{1,2}" or a "dummy-barcode" in the form of "alma\d{6}" | some | string |
| signature | shelfmark of document in collection of the Austrian National Library, for this collection either "PK 507, ddd" or "PK 508, ddd" | all | string |
| location | code for collection department at the Austrian National Library; "POR MAG" stands for the Portrait Collection of the Image Department | all | string |
| urns | ID in the form of a Uniform Resource Name | none | string |
| snISBN | International Standard Book Number | none | string |
| snISSN | International Standard Serial Number | none | string |
| volumeNumber | number of volume as part of a multivolumed resource | none | string |
| languages | code for language of the document in ISO-639 3 | none | string |
| main_title | title of the document, either as in the resource or a fictious title | all | string |
| sub_title | subtitle of the document, either as in the resource or a fictious subtitle  | none | string |
| related_title | any other title related to the document | none | string |
| countryCodes | code for country, in which borders the place of creation lies at the time the catalogue entry was created; ISO-code preceeded by "XA" | none | string |
| persons | personal names of creators and other persons involved (e.g. addressees of letters) in the form {surname, forename} OR {surname, forename, dateOfBirth-dateOfDeath, [MARCRelatorsTerm]}; The MARC relators terms are listed in the MARC documentary: https://www.loc.gov/marc/relators/relaterm.html; the values in this dataset are in German, "MalerIn" stands for "Painter" | all | string |
| corperations | personal name of corperation involved | none | string |
| publishers | personal name of publisher if known | none | string |
| placesOfPublication | placename for place of creation or place of publication, not linked to authority file; "Ohne Ort" stands for "no placename known"; Cave: Those entries that do not have a value do not necessarely have no place of publication | none | string |
| yearOfPublication | year of creation of the artwork | all | integer |
| dateOfPublication | year of creation of the artwork, identical to "yearOfPublication" | all | integer |
| Subjects | subject terms in German as used in the RSWK (Regeln für Schlagwortkatalogisierung), usually in the form of the GND authority file; the subject term can also be a term for a document type (e.g. "Pflanzen"); Please note that the subject terms are not fully consistent within the dataset | most | string |
| GND-Links | URLs (PIDs) for GND-referenced subject terms; multiple values are comma separated | most | string |
| gndReferences | | some | string |
| classifications | NA | some | string |
| contentInformations | pyhsical description of the document | all | string |
| physicalPages | number of pages; for this dataset every item is one page | none | string |
| illustrations | information about the illustrations; for this dataset the number of illustration per page is one | none | string |
| physicalFormat | dimensions of the leaves in centimeter | most | string |
| sequence | NA | none | string |
| urls | URL to entry in ÖNB Digital  | all | string |
| idnr |  ID for the MARC record in the Austrian Union Catalogue; Please refer to this ID for the bibliographic description in the public catalogue (OPAC); in the form of "\{GZ\d{8}\}" where "G" stands for "Gideon", the database the data was migrated from into the library system ALMA | all | string |
