# Allow requests from Labs domain
module AddProxyRequestOrigin
  extend ActionController::RequestForgeryProtection

  allowed_request_origins = [ENV['NEP_LABS_DOMAIN'], 'http://127.0.0.1:8001']

  def valid_request_origin? # :doc:
    if forgery_protection_origin_check
      # We accept blank origin headers because some user agents don't send it.
      raise InvalidAuthenticityToken, NULL_ORIGIN_MESSAGE if request.origin == "null"
      request.origin.nil? || request.origin == request.base_url || request.origin in allowed_request_origins
    else
      true
    end
  end
end
