import { Controller } from "stimulus"
import {DatasetAPI} from "../utils/dataset_api"
import {SearchAPI} from "../utils/search_api";

export default class extends Controller {
    static targets = [ "inputPage" ]
    static values = { id: Number, currentPage: Number, nbPages: Number, perPage: Number, sort: String, sortOrder: String, selectedDocuments: Array }

    connect() {
        this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, "article")
        this.load_named_entities()
        $("#doctype_selection input").on("change", (event) => {
            this.currentPageValue = 1
            this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, $(event.currentTarget).data("doctype"))
        })
        $("#dataset_sort_select").on("change", (event) => {
            this.sortValue = $("#dataset_sort_select :selected").data("sort")
            this.sortOrderValue = $("#dataset_sort_select :selected").data("order")
            this.currentPageValue = 1
            this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, $("#doctype_selection input:checked").data("doctype"))
        })
    }

    toggleResultSelection(event){
        if(!['A', 'IMG'].includes(event.target.tagName)) {
            $(event.target).parents("div.dataset_document").toggleClass("selected")
        }
    }

    toggleSharingStatus(event) {
        if (document.getElementById("sharing_status").innerText == "Private") {
            if (confirm("By clicking OK you agree that your username will be publicly displayed next to your dataset")) {
                DatasetAPI.toggleSharingStatus(this.idValue, (data) => {
                    document.getElementById("dataset-info").outerHTML = data
                })
            }
        } else {
            DatasetAPI.toggleSharingStatus(this.idValue, (data) => {
                document.getElementById("dataset-info").outerHTML = data
            })
        }
    }

    export(event) {
        DatasetAPI.exportDataset(this.idValue, event.target.dataset["exportType"], (data) => {
            $("#notifications").append(data)
            for(const notif of $('.toast')) {
                const notifToast = bootstrap.Toast.getOrCreateInstance(notif)
                notifToast.show()
                notif.addEventListener('hidden.bs.toast', (event) => {
                    bootstrap.Toast.getOrCreateInstance(event.target).dispose()
                    event.target.remove()
                })
            }
        })
    }

    deleteSelectedDocuments(event) {
        const documentsIds = $(".dataset_document.selected").map((index, document) => {
            return document.getAttribute("data-doc-id")
        }).get()
        DatasetAPI.removeSelectedDocumentsToWorkingDataset(documentsIds, (data)=> {})
    }

    loadDocuments(datasetId, page, per_page, sort, sort_order, type) {
        $("#documents-list").html(`<div class="spinner-border"></div>`)
        DatasetAPI.paginateDataset(datasetId, page, per_page, sort, sort_order, type, (data) => {
            $("#documents-list").html(data.documents)
            $("#results_navigation").html(data.pagination)
            this.nbPagesValue = data.nb_pages
        })
    }

    load_named_entities() {
        SearchAPI.load_dataset_named_entities(this.idValue, (data) => {
            $('#named-entities-panel').find(".card-body").html(data)
        })
    }

    previous_page(event) {
        event.preventDefault()
        if (this.currentPageValue > 1) {
            this.currentPageValue--
            this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, $("#doctype_selection input:checked").data("doctype"))
        }
    }

    next_page(event) {
        event.preventDefault()
        if (this.currentPageValue < this.nbPagesValue) {
            this.currentPageValue++
            this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, $("#doctype_selection input:checked").data("doctype"))
        }
    }

    page_button(event) {
        event.preventDefault()
        this.currentPageValue = event.target.textContent
        this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, $("#doctype_selection input:checked").data("doctype"))
    }

    page_select(event) {
        event.preventDefault()
        const input_page = parseInt(this.inputPageTarget.value)
        if (!isNaN(input_page) && 1 <= input_page && input_page <= this.nbPagesValue && !(this.currentPageValue == input_page)) {
            this.currentPageValue = input_page
            this.loadDocuments(this.idValue, this.currentPageValue, this.perPageValue, this.sortValue, this.sortOrderValue, $("#doctype_selection input:checked").data("doctype"))
        }
    }
}