module ApplicationCable
  ##
  # This class identifies the current user in a websocket communication using ApplicationCable
  class Connection < ActionCable::Connection::Base
    identified_by :current_user

    def connect
      self.current_user = find_user
    end

    def find_user
      if current_user = User.find_by(id: cookies.encrypted['_web_session']['current_user_id'])
        current_user
      else
        reject_unauthorized_connection
      end
    end
  end
end
