# Anno Event 2023

In diesem Repo sammeln wir Ressourcen für den Programmpunkt „Vom Bild zum Text – automatische Texterkennung mit Hilfe von OCR“ beim Event **20 Jahre ANNO – Österreichs größtes Webportal von historischen Zeitungen** am 19. Oktober 2023.

## Inhalt

- Arbeitsschritte der OCR
- Annolyzer
- Preprocessing pipeline für Esperanto-Bestände
- Verwendung von Tesseract
- Verwendung von Transkribus

## Arbeitsschritte der OCR

...

## Annolyzer

Die Annolyzer-Plattform ist ein Werkzeug, welches entwickelt wurde um vereinfachten Zugriff auf historische Zeitschriften für eine große Palette von Benutzern zur Verfügung zu stellen. Es handelt sich dabei um eine Weiterentwicklung aus dem NewsEye Projekt, welches nach Projektende in die ÖNB Labs integriert wurde. Siehe den [entsprechenden Beitrag](https://labs.onb.ac.at/de/topic/annolyzer/) auf der Webseite der ÖNB Labs zum Thema. Beim Event stellen wir den Verwendungszweck der Plattform und ihre Funktionen vor:
- Korpus bestehend aus vier österreichischen Zeitschriften aus dem 19. und 20. Jahrhundert
- solr-basierte Volltext-Suche, Filter und Viewer
- Erstellen von eigenen Datensets und Download

## Preprocessing pipeline für Esperanto-Bestände

Für zwei Projekte, die sich mit Beständen der Sammlung für Plansprachen befassen, kommt eine speziell dafür entwickelte Bildverarbeitungs-Pipeline zum Einsatz. Diese ist zugeschnitten auf das historische Bildmaterial und beseitigt Scanränder, rotiert Bilder waagerecht und wandelt das Bild in Graustufen um. Siehe das Jupyter-Notebook [preprocessing-showcase.ipynb](preprocessing-showcase.ipynb) für mehr Details.

## Verwendung von Tesseract

Dies ist eine freie Software für die Texterkennung mit vielen Einstellungen wie etwa unterschiedliche Sprachen und Layoutanalyse.

## Verwendung von Transkribus

Transkribus ist ein Softwarepaket, das auf die Erkennung von (historischen) Handschriften spezialisiert ist. Wir demonstrieren die Verwendung dieses Tools im Projekt [Bibliotheca Eugeniana Digital](https://labs.onb.ac.at/bed/).
