export LC_ALL=C.UTF-8

mkdir -p manifests
echo "" > fetch_manifest.sh

# get all Zz Sign + barcodes
grep -i "BE.1-5.Zz" ../data_ort_corr.tsv | awk '{print $2, $3}' > all_Zz.txt

# get all lines with regular years
grep -P 'Vol.[0-9]{4}' all_Zz.txt | sed -e 's/.*(Vol.//;s/\..*)//' | awk '{ print $2, $1}' > result
grep -P '\([0-9]{4}\)' all_Zz.txt | sed -e 's/.*(//;s/)//' | awk '{ print $2, $1}' >> result


# fetch manifest to get missing yers
grep -P -v 'Vol.[0-9]{4}' all_Zz.txt | grep '\+Z' | awk '{print "curl https://iiif.onb.ac.at/presentation/ABO/"$2"/manifest/ > manifests/"$2".json"}' >>  fetch_manifest.sh
grep -P -v '\([0-9]{4}\)' all_Zz.txt | grep '\+Z' | awk '{print "curl https://iiif.onb.ac.at/presentation/ABO/"$2"/manifest/ > manifests/"$2".json"}' >>  fetch_manifest.sh

./fetch_manifest.sh

# process json files and extract years
grep -i "\"value\" : \"Vol." manifests/*.json | sed -e 's/manifests\///;s/.json:.*"Vol.[0-9]*./ /;s/ [0-9]\./ /;s/"//;s/(.*)$//;s/,$//;s/\./-/;s/-.*$//' >> result

cat result | awk 'BEGIN{print "barcode\tzzyear"}{print $1"\t"$2}' > ../resultzz.tsv

echo '# resultzz.tsv generated #'
echo '# done #'

exit

# get page2 of all files to check validity
# mkdir -p page2
# cat result | awk '{print "curl https://iiif.onb.ac.at/images/ABO/"$1"/00000002/full/full/0/native.jpg > page2/"$2"_"$1".jpg"}' > fetch_page2.sh
# ./fetch_page2.sh
