import {defineConfig} from 'vite'
import react from '@vitejs/plugin-react'
import fixReactVirtualized from 'esbuild-plugin-react-virtualized'
import macrosPlugin from "vite-plugin-babel-macros";

// https://vitejs.dev/config/
export default defineConfig({
		plugins: [
			react(),
			macrosPlugin(),
		],
		define: {
		'__APP_VERSION__': JSON.stringify(process.env.npm_package_version),
		'process.env': process.env,
		},
	base: '',
	optimizeDeps: {
		esbuildOptions: {
			plugins: [fixReactVirtualized],
		},
	},
})

