import {defineConfig} from 'vite'
import react from '@vitejs/plugin-react'
import fixReactVirtualized from 'esbuild-plugin-react-virtualized'
import * as fs from "fs"
import * as path from "path"
import macrosPlugin from "vite-plugin-babel-macros"

const update_build = () => {
	try {
		fs.readFile('src/metadata.json',function(err,content) {
				if (err) throw err;
				// update metadata
				var metadata = JSON.parse(content);
				metadata.build = metadata.build + 1;
				fs.writeFile('src/metadata.json', JSON.stringify(metadata), function (err) {
					if (err) throw err;
				})
				// update package JSON
				const packageFilePath = path.join(__dirname, 'package.json');
				const packageJson = JSON.parse(fs.readFileSync(packageFilePath, 'utf8'));
				packageJson.version = metadata.version + '.' + metadata.build
				fs.writeFileSync(packageFilePath, JSON.stringify(packageJson, null, 2));
				console.log('New version is', packageJson.version);
		})

	} catch (error) {
		console.log('Error in increasePackageVersion', error);
	}
}

// https://vitejs.dev/config/
export default defineConfig({
	plugins: [
		react(),
		update_build(),
		macrosPlugin(),
	],
	define: {
		'__APP_VERSION__': JSON.stringify(process.env.npm_package_version),
		'process.env': process.env,
	},
	base: '',
	optimizeDeps: {
		esbuildOptions: {
			plugins: [fixReactVirtualized],
		},
	},
})
