///* eslint-disable react/prop-types */
/* eslint no-unused-vars: ["error", { "ignoreRestSiblings": true }] */

import { create } from 'zustand';
import { parseTSV } from './lib/parse-tsv';
//import React from "react";

const initalState = {
    loading: false,
    success: false,
    error: false,
    data: null,
    errorData: null,
    dataBySignature: null,
    dataByMembership: null,
}

const languageTranslations = {
    "French": "Französisch",
    "Latin": "Latein",
    "German": "Deutsch",
    "Italian": "Italienisch",
    "English": "Englisch",
    "unknown": "Unbekannt",
    "Spanish": "Spanisch",
    "Greek, Ancient (to 1453)": "Altgriechisch (bis 1453)",
    "Dutch": "Niederländisch",
    "Swedish": "Schwedisch",
    "Hungarian": "Ungarisch",
    "Russian": "Russisch",
    "Danish": "Dänisch",
    "Portuguese": "Portugiesisch",
    "Greek, Modern (1453- )": "Neugriechisch (ab 1453)",
    "Multiple languages": "Mehrere Sprachen",
    "Arabic": "Arabisch",
    "Hebrew": "Hebräisch",
    "Sanskrit": "Sanskrit",
    "Tamil": "Tamil",
    "Polish": "Polnisch",
    "Czech": "Tschechisch",
    "Icelandic": "Isländisch",
    "Croatian (Old Code)": "Kroatisch (alter Code)",
    "Slovenian": "Slowenisch",
    "Syriac, Modern": "Modernes Syrisch",
    "Persian": "Persisch",
    "Romanian": "Rumänisch",
    "Turkish": "Türkisch",
    "Latvian": "Lettisch",
    "Church Slavic": "Kirchenslawisch",
    "None of the above": "Keine der genannten",
    "Sami": "Samisch",
    "Ethiopic": "Äthiopisch",
    "Karelian": "Karelisch",
    "Slovak": "Slowakisch",
    "Armenian": "Armenisch",
    "Sorbian (Other)": "Sorbisch (Andere)",
    "Catalan": "Katalanisch"
};


export const useStore = create((set, get) => ({     // eslint-disable-line

    ...initalState,

    fetchData: async (filePath) => {
        set({...initalState, loading: true });
        try {
          const response = await fetch(filePath);
          const textData = await response.text();
          const parsedData = parseTSV(textData);
//          set({...initalState, data: addMembership(parsedData), loading: false, success: true});
          set({...initalState, data: parsedData, loading: false, success: true});
        } catch (error) {
          set({...initalState, error: error, loading: false, success: false });
        }
      },

    // -----------------------------------
    // basic layout dimensions
    // -----------------------------------

    dim: {},
    setDim: (dim) => set(() => ({dim})),

    remInPx: 16,
    setRemInPx: (remInPx) => set(() => ({remInPx})),

    dummyRowHeight: {},
    setDummyRowHeight: (dummyRowHeight) => set(() => ({dummyRowHeight})),

	firstRender: false,
    setFirstRender: (firstRender) => set(() => ({firstRender})),

    nightMode: false,
    setNightMode: (nightMode) => set(() => ({nightMode})),

    // -----------------------------------
    // interactions
    // -----------------------------------

//    currentShelf: 'BE.1.',
    currentShelf: false,
    setCurrentShelf: (currentShelf) => set(() => ({currentShelf})),

    hoverShelf: null,
    setHoverShelf: (hoverShelf) => set(() => ({hoverShelf})),

    selectedBook: false,
    setSelectedBook: (selectedBook) => set(() => ({selectedBook})),
    
    hoveredBook: false,
    setHoveredBook: (hoveredBook) => set(() => ({hoveredBook})),

    hoveredPlace: false,
    setHoveredPlace: (hoveredPlace) => set(() => ({hoveredPlace})),

    hoveredLanguage: false,
    setHoveredLanguage: (hoveredLanguage) => set(() => ({hoveredLanguage})),

    hoveredMember: false,
    setHoveredMember: (hoveredMember) => set(() => ({hoveredMember})),

    hoveredColor: false,
    setHoveredColor: (hoveredColor) => set(() => ({hoveredColor})),

    hoveredTaxonomy: false,
    setHoveredTaxonomy: (hoveredTaxonomy) => set(() => ({hoveredTaxonomy})),

    hoveredSection: false,
    setHoveredSection: (hoveredSection) => set(() => ({hoveredSection})),

    holdHoveredSection: false,
    setHoldHoveredSection: (holdHoveredSection) => set(() => ({holdHoveredSection})),

    mouse: false,
    setMouse: (mouse) => set(() => ({mouse})),

    mouseScreen: false,
    setMouseScreen: (mouseScreen) => set(() => ({mouseScreen})),

    zoomShelf: true,
    setZoomShelf: (zoomShelf) => set(() => ({zoomShelf})),

    search: '',
    setSearch: (search) => set(() => ({search})),

    filterMembership: null,
    setFilterMembership: (filterMembership) => set(() => ({filterMembership})),

    filterTimerange: null,
    setFilterTimerange: (filterTimerange) => set(() => ({filterTimerange})),

    filterPlace: null,
    setFilterPlace: (filterPlace) => set(() => ({filterPlace})),

    filterLanguage: null,
    setFilterLanguage: (filterLanguage) => set(() => ({filterLanguage})),
    
    filterTaxonomy: null,
    setFilterTaxonomy: (filterTaxonomy) => set(() => ({filterTaxonomy})),

    selectedCity: null,
    setSelectedCity: (selectedCity) => set(() => ({selectedCity})),
    
    selectedHighlight: null,
    setSelectedHighlight: (id) => set({ selectedHighlight: id }),

    highlightsOffset: 0,
    setHighlightsOffset: (highlightsOffset) => set(() =>({ highlightsOffset })),

    selectedLegend: false,
    setSelectedLegend: (selectedLegend) => set(() =>({ selectedLegend })),
    

    // -----------------------------------
    // data storage
    // -----------------------------------

    storedCats: null,
    setStoredCats: (storedCats) => set( () => ({storedCats})),

    storedPlaces: null,
    setStoredPlaces: (storedPlaces) => set( () => ({storedPlaces})),

    storedLanguages: null,
    setStoredLanguages: (storedLanguages) => set( () => ({storedLanguages})),

    storedSubCats: null,
    setStoredSubCats: (storedSubCats) => set( () => ({storedSubCats})),

    stats: null,
    setStats: (stats) => set( () => ({stats})),

    timeline: null,
    setTimeline: (timeline) => set( () => ({timeline})),

    taxonomy: null,
    setTaxonomy: (taxonomy) => set( () => ({taxonomy})),

    taxonomyd3: null,
    setTaxonomyd3: (taxonomyd3) => set( () => ({taxonomyd3})),

    places: null,
    setPlaces: (places) => set( () => ({places})),

    geo: null,
    setGeo: (geo) => set( () => ({geo})),
    
    unknownPlacesData: { count: 0, books: [], categories: {} },
    setUnknownPlacesData: (data) => set({ unknownPlacesData: data }),

//    sortSection: 'date',
    sortSection: 'signatur',
    setSortSection: (sortSection) => set( () => ({sortSection})),


    // -----------------------------------
    // views
    // -----------------------------------


    mode: 'memberships',
    setMode: (mode) => set( () => ({mode})),

    chartType: 'member',
    setChartType: (chartType) => set( () => ({chartType})),

    showWelcome: false,
    setShowWelcome: (showWelcome) => set(() => ({showWelcome})),

    showHighlights: true,
    setShowHighlights: (showHighlights) => set(() => ({showHighlights})),

	showShelfHint: false,
	setShowShelfHint: (showShelfHint) => set(() => ({showShelfHint})),

	showTouchHint: false,
    setShowTouchHint: (showTouchHint) => set(() => ({showTouchHint})),

    showHintNonDigitized: false,
    setShowHintNonDigitized: (showHintNonDigitized) => set(() => ({showHintNonDigitized})),

    showCloseup: false,
    setShowCloseup: (showCloseup) => set( () => ({showCloseup})),

    showTutorial: false,
    setShowTutorial: (showTutorial) => set( () => ({showTutorial})),

    showTour: false,
    setShowTour: (showTour) => set( () => ({showTour})),

    showStories: false,
    setShowStories: (showStories) => set( () => ({showStories})),

    showImpressum: false,
    setShowImpressum: (showImpressum) => set( () => ({showImpressum})),

    showIntro: true,
    setShowIntro: (showIntro) => set( () => ({showIntro})),
    
    activeComponent: null,
    setActiveComponent: (component) => set({ activeComponent: component }),
    
    isGerman: true,
    setIsGerman: (isGerman) => set( () => ({isGerman})),
    
    languageTranslations,
    translateLanguage: (language) => {
        return get().languageTranslations[language] || language;
    },

    autoShowTips: true, // true means tips show automatically
    setAutoShowTips: (value) => set({ autoShowTips: value }),
    
    
    // -----------------------------------
    // static vars
    // -----------------------------------

    shelvesList: [
        'BE.1', 'BE.2', 'BE.3', 'BE.4', 'BE.5', 'BE.6', 'BE.7', 'BE.8', 'BE.9', 'BE.10', 'BE.11', 'BE.12',
    ],
    sections: [
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z', 'Zz',
    ],

    ZZsections: [
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z', 'ZZ.links','ZZ.rechts',
    ],

    colors: {
        "Farbklassifizierung": {
            "uncertain": "white",
            "noneugeniana": "#A6A6A6",
            "blue": '#1f78b4',
            "red": '#e31a1c',
            "yellow": '#ffdb58',
        },
        "FarbklassifizierungInner": {
            "uncertain": "#213547",
            "noneugeniana": "#E4E4E4",
            "blue": '#B1EEFF',
            "red": '#FCA3A7',
            "yellow": '#213547',
        },

        "Wappenklassifizierung": {
            "N": "lightgray",
            "A": "#ff7c80",
            "B": "#ff7c80",
            "C": "#ff7c80",
            "uncertain": "#FBBE97",
        },
//        "membership": ["lightgray", "#ff7c80", "#FBBE97"]
        "membership": ["#A6A6A6", "#FF6569",
        "#FFB66D"],
//        "#ff9e24"],
//        "#f09d2b"],
        "membershipInner": ["#FFFFFF", "#FFFFFF", "#213547"],
    },

    legend: 'white',
    updateLegend: () => {
        set((state) => ({
            legend: {
                "memberships": [
                    {color: state.colors.membership[1], text: 'Eugeniana', title: 'Eugeniana'},
                    {color: state.colors.membership[2], text: 'unsicher', title: 'unsicher'},
                    {color: state.colors.membership[0], text: 'Nicht Eugeniana', title: 'Nicht Eugeniana'},
                ],
                "colors": [
                    {color: state.colors.Farbklassifizierung.yellow, text: 'Eugeniana-gelb', title: 'Eugeniana gelber Einband (Naturwissenschaften?)'},
                    {color: state.colors.Farbklassifizierung.red, text:'Eugeniana-rot', title: 'Eugeniana roter Einband (Geschichte und Literatur?)'},
                    {color: state.colors.Farbklassifizierung.blue, text:'Eugeniana-blau', title: 'Eugeniana blauer Einband (Theologie?)'},
                    {color: state.colors.Farbklassifizierung.uncertain, text:'unsicher', title: 'Klassifizierung unsicher'},
                    {color: state.colors.Farbklassifizierung.noneugeniana, text:'Nicht Eugeniana', title: 'Nicht im Bestand der Europeana'},
                ],
                "map": [
                    {icon: 'circle-open', text: 'unter 10', title: 'unter 10 Exemplare'},
                    {icon: 'circle-full', text: '10 oder mehr', title: 'mehr als 10 Exemplare'},
                ]
            },
        }))
    },

    // -----------------------------------
    // screen & devices & orientation
    // -----------------------------------

    layoutInitialized: false,
    setLayoutInitialized: (layoutInitialized) => set(() => ({layoutInitialized})),

    smallDevice: false,
    setSmallDevice: (smallDevice) => set(() => ({smallDevice})),

    isTouch: false,
    setIsTouch: (isTouch) => set(() => ({isTouch})),

    isPrimaryTouch: false,
    setIsPrimaryTouch: (isPrimaryTouch) => set(() => ({isPrimaryTouch})),

    isHybridTouch: false,
    setIsHybridTouch: (isHybridTouch) => set(() => ({isHybridTouch})),

    wasTouched: false,
    setWasTouched: (wasTouched) => set(() => ({wasTouched})),

    isIOS: false,
    setIsIOS: (isIOS) => set(() => ({isIOS})),

    isFirefox: false,
    setIsFirefox: (isFirefox) => set(() => ({isFirefox})),

    IOSOrientation: false,
    setIOSOrientation: (IOSOrientation) => set(() => ({IOSOrientation})),

    mobile: false,
    setMobile: (mobile) => set(() => ({mobile})),

    landscape: false,
    setLandscape: (landscape) => set(() => ({landscape})),

    portrait: true,
    setPortrait: (portrait) => set(() => ({portrait})),

    mobileHeight: 0,
    setMobileHeight: (mobileHeight) => set(() => ({mobileHeight})),

    mobileWidth: 0,
    setMobileWidth: (mobileWidth) => set(() => ({mobileWidth})),



}));


//const addMembership = (data) => {
//    // membership: 0 .. nicht eugeniana, 1 .. eugeniana; 2 ..unsicher
//    // Sicher Eugeniana
//    // - Wappenklassifizierung in [A ODER B ODER C]  UND  p_* >= 0.8  UND  Jahr ist leer ODER <= 1736
//
//    // Sicher nicht Eugeniana
//    // - (Wappenklassifizierung leer  ODER  N UND p_* >= 0.8) UND Jahr ist NICHT leer UND > 1736
//
//    // Unsicher
//    // alle anderen
//    const certaintyThreshold = 0.8;
//    const cutoffYear = 1736; //Sterbejahr; alles ab 1737 gehört nicht zu Eugeniana
//
//    return data.map((book) => {
//        return {
//            ...book,
//            membership: ( (book['Wappenklassifizierung'] === '') || (book['Wappenklassifizierung'] === 'N' && book['p_N'] >= certaintyThreshold) ) &&
//            (!isNaN(book['Anfang Veröffentlichungsdatum']) && +book['Anfang Veröffentlichungsdatum'] > cutoffYear) ? 0 :
//                ( (book['Wappenklassifizierung'] === 'A' && book['p_A'] >= certaintyThreshold) ||
//                    (book['Wappenklassifizierung'] === 'B' && book['p_B'] >= certaintyThreshold) ||
//                    (book['Wappenklassifizierung'] === 'C' && book['p_C'] >= certaintyThreshold) )
//                && (isNaN(book['Anfang Veröffentlichungsdatum']) || +book['Anfang Veröffentlichungsdatum'] <= cutoffYear) ? 1 : 2
//        }
//    })
//}



