import metadata from "../metadata.json";
import preval from "preval.macro";
import React, {useLayoutEffect, useState, useEffect} from "react";

/*

SETUP:

npm install preval.macro

then generate json file:
/src/metadata.json
{"version":"0.1","build":2}

---
in vite.cfg.js add the following function:

const update_build = () => {
	try {
		fs.readFile('src/metadata.json',function(err,content) {
				if (err) throw err;
				// update metadata
				var metadata = JSON.parse(content);
				metadata.build = metadata.build + 1;
				fs.writeFile('src/metadata.json', JSON.stringify(metadata), function (err) {
					if (err) throw err;
					console.log("Current build number: " + metadata.build);
				})
				// update package JSON
				const packageFilePath = path.join(__dirname, 'package.json');
				const packageJson = JSON.parse(fs.readFileSync(packageFilePath, 'utf8'));
				packageJson.version = metadata.version + '.' + metadata.build
				fs.writeFileSync(packageFilePath, JSON.stringify(packageJson, null, 2));
				console.log('New version is', packageJson.version);
		})

	} catch (error) {
		console.log('Error in increasePackageVersion', error);
	}
}

---
also generate empty .env file and create a variable in vite.config
define: {'process.env': process.env}

---
then use this config for the build command

=> done!
 */

export function logVersion (appName) {
	let name = appName ?? ''
	const zeroPad = (num, places) => String(num).padStart(places, '0')
	return console.log(name+' v'+metadata.version+'b'+zeroPad(metadata.build, 3), preval`module.exports = new Date().toLocaleString();`)
}



export function Version () {

	const zeroPad = (num, places) => String(num).padStart(places, '0')

	const style = {fontSize: '0.9em', margin: '5px', color: 'grey'};

	return (
	<div style={style}>
		v{metadata.version}.b{zeroPad(metadata.build, 3)}, {preval`module.exports = new Date().toLocaleString();`}
	</div>
	)

}


