export const parseTSV = (tsv) => {
    
    const cleanTSV = tsv
        .replace(/\r\n/g, '\n')  // Normalize line endings
        .replace(/[\x00-\x08\x0B-\x1F\x7F]/g, '');  // Remove control chars except tabs(\x09) and newlines(\x0A)
    
    // Split the TSV into rows, filter out empty rows
    const rows = cleanTSV.split('\n').filter(row => row.trim() !== '');
    
    // Extract headers from the first row
    const headers = rows[0].trim().split('\t');
    
    // Parse data from the remaining rows
    const parsedData = rows.slice(1).map(row => {
        const values = row.trim().split('\t');
        return headers.reduce((obj, header, index) => {
            obj[header] = values[index];
            return obj;
        }, {});
    });
    
    return parsedData;
};
