// categories.js
export const createColorCategories = (stats, colors, hoverShelf) => {
	return [
		{
			label: 'Nicht Eugeniana',
			id: 'noneugeniana',
			value: 0,
			idx: 5,
			data: stats.categories.noneugeniana,
			dataSub: hoverShelf ? stats.subcategories.noneugeniana[hoverShelf] : [],
			fill: colors.Farbklassifizierung.noneugeniana,
			textOffset: 0,
			tX: 1,
			tY: -1
		},
		{
			label: 'unsicher',
			id: 'uncertain',
			idx: 4,
			value: 2,
			data: stats.categories.uncertain,
			dataSub: hoverShelf ? stats.subcategories.uncertain[hoverShelf] : [],
			fill: colors.Farbklassifizierung.uncertain,
			textOffset: 0,
			tX: 0.25,
			tY: 0.85
		},
		{
			label: 'Eugeniana-Naturwissenschaften',
			id: 'eugeniana',
			subid: 'yellow',
			value: 1,
			idx: 1,
			data: stats.categories.eugeniana_yellow,
			dataSub: hoverShelf ? stats.subcategories.eugeniana_yellow[hoverShelf] : [],
			fill: colors.Farbklassifizierung.yellow,
			filter: '#ff7c8099',
			textOffset: 0,
			tX: -2,
			tY: -4.3
		},
		{
			label: 'Eugeniana-Geschichte und Literatur',
			id: 'eugeniana',
			idx: 2,
			subid: 'red',
			value: 1,
			data: stats.categories.eugeniana_red,
			dataSub: hoverShelf ? stats.subcategories.eugeniana_red[hoverShelf] : [],
			fill: colors.Farbklassifizierung.red,
			filter: '#ff7c8099',
			textOffset: 0,
			tX: -1,
			tY: -1
		},
		{
			label: 'Eugeniana-Theologie und Recht',
			id: 'eugeniana',
			idx: 3,
			subid: 'blue',
			value: 1,
			data: stats.categories.eugeniana_blue,
			dataSub: hoverShelf ? stats.subcategories.eugeniana_blue[hoverShelf] : [],
			fill: colors.Farbklassifizierung.blue,
			filter: '#ff7c8099',
			textOffset: -34,
			tX: 1,
			tY: -16
		}
	];
};

// membershipCategories.js
export const createMembershipCategories = (stats, colors, hoverShelf) => {
	return [
		{
			label: 'Nicht Eugeniana',
			id: 'noneugeniana',
			value: 0,
			idx: 3,
			data: stats.categories.noneugeniana,
			dataSub: hoverShelf ? stats.subcategories.noneugeniana[hoverShelf] : [],
			fill: colors.membership[0],
			tX: 1,
			tY: -1
		},
		{
			label: 'Eugeniana',
			id: 'eugeniana',
			idx: 1,
			value: 1,
			data: stats.categories.eugeniana,
			dataSub: hoverShelf ? stats.subcategories.eugeniana[hoverShelf] : [],
			fill: colors.membership[1],
			filter: '#ff7c8099',
			tX: -1,
			tY: -0.8
		},
		{
			label: 'unsicher',
			id: 'uncertain',
			idx: 2,
			value: 2,
			data: stats.categories.uncertain,
			dataSub: hoverShelf ? stats.subcategories.uncertain[hoverShelf] : [],
			fill: colors.membership[2],
			tX: 0.25,
			tY: 0.85
		}
	];
};
