import styles from "../styles.module.css";

import {useStore} from "../store.js";
import { RiExternalLinkLine } from "react-icons/ri";


export const Tutorial = () => {

	const showTutorial = useStore(state => state.showTutorial)
	const setShowTutorial = useStore(state => state.setShowTutorial)
	const setShowStories = useStore(state => state.setShowStories);
	const colors = useStore(state => state.colors)
	const remInPx = useStore(state => state.remInPx)

    const ExternalLink = ({ href, children }) => (
        <a href={href} target="_blank" rel="noreferrer" className="inline-flex items-center gap-1">
            {children} <RiExternalLinkLine className="inline" size={remInPx*1.1} />
        </a>
    );

	const handleClick = () => {
		setShowTutorial(false)
		setShowStories(true)
	}

	return (

		<div className={styles.tutorialContainer} style={{visibility: showTutorial ? 'visible' : 'hidden'}}>
			<div className={styles.turorialContent}>
				<h2>
					Bibliotheca Eugeniana Digital
				</h2>
				<img src={'00_highlights.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Startseite mit Highlights</b>: Als Einstieg in die Vielfalt der Bibliotheca Eugeniana haben wir
					für Sie einige "Gustostückerl" der Sammlung ausgewählt. Klicken Sie auf die einzelnen Titel, um von
					der Bedeutung dieser Werke zu erfahren und die Bücher im Volltext zu erkunden.
				</p>
				
				<p>
					<b>Historischer Hintergrund</b>: Prinz Eugen von Savoyen (1663–1736) sammelte im Laufe seines Lebens
					mehr als 15.000 Druckschriften und etwa 2.500 Handschriften zu den wichtigsten Themen seiner Zeit.
					Die resultierende Bibliotheca Eugeniana gilt bis heute als eine der bedeutendsten Büchersammlung der
					Barockzeit und wurde als solche in das
					&nbsp;
					<ExternalLink
						href="https://www.unesco.at/kommunikation/dokumentenerbe/memory-of-austria/verzeichnis/detail/article/bibliotheca-eugeniana/">
						Weltkulturerbe der UNESCO
					</ExternalLink>
					&nbsp;
					aufgenommen. Nach dem Tod von Prinz Eugen kaufte der Habsburger Hof die Sammlung und machte sie zum
					Kernbestand der Hofbibliothek im Prunksaal am Josefsplatz, der heute zur österreichischen
					Nationalbibliothek zählt. Näheres dazu finden Sie in der <span
					className={styles.HighlightsLink} onClick={handleClick}>Story</span> zur Sammlung.
				</p>
				<p>
					Im Projekt <i>Bibliotheca Eugeniana Digital</i> wird diese Büchersammlung derzeit neu inventarisiert
					und digital erschlossen. Das Interface ermöglicht es Ihnen, die Sammlung zu erkunden. Nähere
					Informationen zum Projekt und die zugrundeliegenden Daten finden Sie in der{' '}
					<ExternalLink href="https://edition.onb.ac.at/context:eugeniana">
						digitalen Editon
					</ExternalLink>.
				</p>
				
				<img src={'01_interface-overview.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Aufbau des Interfaces</b>: Dieses Interface besteht aus drei miteinander verknüpften Teilen:
					Einer Bücherliste mit Suchfunktion (links), der Ansicht des Prunksaals in der Nationalbibliothek
					(Mitte) und einer visuellen Analyse-Ansicht (rechts). Diese Ansichten werden im Folgenden erklärt,
					können aber auch direkt erkundet werden. Über Bewegung der Maus erscheinen entweder Informationen zu
					allen Elementen des Interface - oder es wird durch Klicken direkt eine Auswahl getroffen.
				
				</p>
				
				
				<img src={'02_regalansicht.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Prunksaal-Ansicht</b>: Die Büchersammlung des Prinzen Eugen von Savoyen befindet sich im
					Mitteloval des Prunksaals der Österreichischen Nationalbibliothek (
					<ExternalLink href="https://www.onb.ac.at/museen/prunksaal/besuch/virtueller-prunksaal">
						3D Rundgang
					</ExternalLink>
					). Eine schematische Rekonstruktion der 12 Regale bildet das Kernstück dieses Interfaces
					(links). <br/>
					Wenn Sie auf ein Regal klicken, wird dieses im Zentrum vergrößert dargestellt und Sie können die
					einzelnen Fächer und Bücher erkunden (rechts). Klicken Sie außerhalb des Regals, wird die Auswahl
					aufgehoben.
				</p>
				
				<img src={'04_zugehoerigkeit.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Farbschema&mdash;Zugehörigkeit zur Originalsammlung</b>: Nicht alle Bücher im Prunksaal waren
					Teil der
					Bibliotheca Eugeniana. Ein Ziel des Forschungsprojektes war es, den aktuellen Umfang dieser Sammlung
					zu
					rekonstruieren und damit die Zugehörigkeit der Bücher zur Originalsammlung zu klären. Die drei
					Kreise
					stellen den aktuellen Erkenntnisstand des Projektes dar.
				</p>
				<ul className={styles.noBullets}>
					<li>
                        <span><Tag color={colors.membership[1]}/><b><font color={colors.membership[1]}>Rot</font></b>
                            : Diese Bücher besitzen ein Wappen des Prinzen Eugen auf dem Einband und sind daher sicher Teil der
							Bibliotheca Eugeniana.</span>
					</li>
					<li>
						<Tag color={colors.membership[2]}/><b><font color={colors.membership[2]}>Orange</font></b>
						: Diese Bücher stammen aus dem fraglichen Zeitraum, es wurde aber kein Wappen gefunden. Für
						diese Bücher
						erfolgt derzeit ein Abgleich mit dem handschriftlichen Katalog der Bibliotheca Eugeniana, um die
						Zugehörigkeit zu klären.
					</li>
					<li>
						<Tag color={colors.membership[0]}/><b><font color={colors.membership[0]}>Grau</font></b>
						: Diese Bücher sind erst nach dem Tod von Prinz Eugen erschienen und daher kein Teil der
						Bibliotheca
						Eugeniana.
					</li>
				</ul>
				
				<img src={'05_einbandfarbe.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Farbschema&mdash;Einbandfarbe</b>: Alternativ zur Zugehörigkeit können Sie als Farbschema die
					Farbe des
					historischen Ledereinbandes wählen. Die bisherige Fachliteratur ging von folgendem Zusammenhang
					zwischen Einbandfarbe und Thema des Buches aus: <b>Blau</b> für Theologie und Recht, <b>Gelb</b> für
					Naturwissenschaften und <b>Rot</b> für Geschichte und Literatur. Wir laden Sie ein, selbst in der
					Buchliste
					und in den Analyseansichten zu erkunden, ob solch ein Zusammenhang Ihrer Meinung nach besteht.
				</p>
				
				<img src={'03_buecherliste.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Bücherliste mit Suchfunktion</b>: Links wird eine Liste aller Bücher, die der aktuellen Auswahl
					entsprechen, dargestellt. Durch Klick auf das Buch, wird eine Volltext-Ansicht geöffnet und Sie
					können darin schmökern.<br/>
					Unterhalb der Bücherliste besteht die Möglichkeit, nach bestimmten Begriffen oder Namen in allen
					Titeln oder Autoren zu suchen und diese damit zu filtern.
				</p>
				
				<img src={'09_taxonomie.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Analyseansicht&mdash;Wissensklassifikation</b>: Die Bücher der Bibliotheca Eugeniana wurden in
					eine historische Wissensklassifikation eingeteilt, die sie hier dargestellt sehen - in ihrer Größe
					der Anzahl der Bücher darin entsprechend.<br/>Klicken Sie auf eine Wissensklasse, um in der
					Bücherliste und der Prunksaal-Ansicht danach zu filtern und die zugehörigen Unterklassen zu sehen.
					Wenn Sie außerhalb des Kreises klicken, gelangen Sie zurück zur Übersicht.<br/>
					Die Klassifikation (ebenso wie alle folgenden Ansichten) können Sie sowohl für die Zugehörigkeit
					als auch für die Einbandfarbe erkunden.
				</p>
				
				
				<img src={'06_zeitlicher-ursprung.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Analyseansicht&mdash;Zeitlicher Ursprung:</b> Wechseln Sie in der Navigationsleiste zum
					Zeit-Symbol, um eine Ansicht zum zeitlichen Ursprung der Sammlung zu erhalten. Sie sehen auf einer
					Zeitleiste (rechts), wie viele Bücher aus einzelnen Zeitabschnitten stammen. Wenn Sie den grauen
					Balken nach links oder rechts schieben bzw. breiter oder schmäler machen, können Sie einen Zeitraum
					auswählen, aus dem die Bücher im Prunksaal und in der Buchliste angezeigt werden. Über die
					Einstellung des Intervalls (in violett) können Sie die Zeitintervalle für die Balken auf der
					Zeitleiste verändern.
				</p>
				
				<img src={'07_raeumlicher-ursprung.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Analyseansicht&mdash;Räumlicher Ursprung:</b> Wechseln Sie in der Navigationsleiste zum Globus,
					um
					einen Überblick über die wichtigsten Erscheinungsorte zu erhalten. Auf einer Karte sehen Sie Kreise
					an diesen
					Orten - in ihrer Größe ihrer Häufigkeit entsprechend. Sie können auf der Karte zoomen und die Karte
					nach
					rechts oder links ziehen, um auch Erscheinungsorte in Asien und Übersee zu sehen.<br/>
					Bewegen Sie die Maus auf den Kreis, um die Anzahl der dort erschienen Bücher zu sehen. Klicken Sie
					auf
					den Kreis, um nach diesem Erscheinungsort in der Prunksaal-Ansicht und in der Bücherliste zu
					filtern.<br/>
					Klicken Sie auf "Eugeniana" über der Prunksaal-Ansicht, um nur die Erscheinungsorte der Bücher aus
					der
					Bibliotheca Eugeniana zu sehen. Mit einem nochmaligen Klick heben Sie diese Auswahl wieder auf.
				</p>
				
				<img src={'08_sprache.png'} className={styles.turorialImage}/>
				
				<p>
					<b>Analyseansicht&mdash;Sprache:</b> Klicken Sie in der Navigationsleiste auf die Sprechblase, um
					Informationen zur Sprache der Bücher zu erhalten. Diese sind nach Häufigkeit geordnet aufgelistet.
					Durch Klicken auf eine Sprache, können Sie nach dieser Sprache in der Bücherliste und der
					Prunksaalansicht
					filtern.<br/>
					Klicken Sie auf "Eugeniana" über der Prunksaal-Ansicht, um nur die Sprache der Bücher aus der
					Bibliotheca
					Eugeniana zu sehen. Mit einem nochmaligen Klick heben Sie diese Auswahl wieder auf.
				</p>
				
				<p>
					Danke für Ihr Interesse und viel Freude beim Erkunden!
				</p>
				<p>
					Sollten Sie Fragen, Anregungen oder Rückmeldungen haben, freuen wir uns über Ihre
					Kontaktaufnahme
					unter&nbsp;
					<span style={{whiteSpace: 'nowrap', wordBreak: 'keep-all !important', hyphens: 'none'}}>
                        <a href="mailto:bed-project@onb.ac.at">bed-project[AT]onb.ac.at</a>
					</span>
				</p>
				
				<div className={styles.Button} width={'max-content'}
				     style={{width: 'max-content', marginLeft: '80%', marginRight: 'auto'}}
				     onClick={() => setShowTutorial(false)}>Tutorial schließen
				</div>
				
				<div
					className={styles.close}
					onClick={() => setShowTutorial(false)}
				>&#10006;</div>
			</div>
		</div>
	)
}


const Tag = (props) => {
	return (
		<span className={styles.tutorialTag} style={{backgroundColor: props.color}}>&nbsp;</span>
	)
}
