import {useStore} from "../store.js";
import React, {useEffect, useState} from "react";
import styles from "../styles.module.css";
import {GeoMap} from "./Map.jsx";
import CirclePacking from "./CirclePacking.jsx";

const contentStyle = {
	head: {
		width: '100%',
		maxWidth: '80vw',
		margin: '0 auto',
		padding: '4rem 3rem 4rem 5rem',
		position: 'relative',
		background: '#F5ECD8',
		color: '#000000',
		fontFamily: 'Saira Semi Condensed',
	},
	textContainer: {
		fontSize: '1.1em',
		maxWidth: '50vw',
		margin: '0 auto',
		padding: '2rem',
		position: 'relative',
		textAlign: 'left',
		fontFamily: 'Saira Semi Condensed',
	},
	mainTitle: {
		fontSize: '2.5rem',
		fontWeight: 'bold',
		margin: '1.5rem 3rem 3rem -2rem',
		padding: '0 4rem 0.5rem 0'
	},
	section: {
		marginBottom: '2rem'
	},
	sectionTitle: {
		fontSize: '2rem',
		fontWeight: 'bold',
		marginBottom: '1rem'
	},
	sideBySide: {
		display: 'flex',
		justifyContent: 'space-between',
		alignItems: 'flex-end',
		marginBottom: '1rem',
		marginLeft: '-4rem',
		width: '100%',
	},
	imageWithCaption: {
		display: 'flex',
		flexDirection: 'column',
		alignItems: 'center',
		minWidth: '45%',              // Set minimum width to prevent squishing
	},
	sidebySideImage: {
		display: 'flex',
		justifyContent: 'center',
	},
	sideBySideCaption: {
		width: '100%',
		textAlign: 'center',
		marginTop: '0.5rem',
		marginBottom: '1rem'
	},
	
	caption: {
		marginLeft: '-5rem',
		marginTop: '-1rem',
		fontSize: '0.9em',
		//		color: '#666'
	},

	floatRight: {
		float: 'right',
		marginLeft: '2rem',
		marginBottom: '1rem',
		maxWidth: '40%'
	},
	floatLeft: {
		background: 'white',
		float: 'left',
		padding: '2em 2em 0 2em',
		marginLeft: '2rem',
		marginRight: '2rem',
		marginTop: '-1rem',
//		marginBottom: '1rem',
		maxWidth: '20rem'
	},
	fullWidthImage: {
		marginLeft: '-6rem',
		marginRight: '-3rem',
		width: '130%',
		maxWidth: '60rem',
		marginBottom: '1rem'
	},
	quote: {
		fontStyle: 'italic',
		margin: '2rem 0',
		paddingLeft: '2rem',
		borderLeft: '4px solid #ccc'
	},
};

export const Stories = () => {
	
	const showStories = useStore(state => state.showStories);
	const setShowStories = useStore(state => state.setShowStories);
	const dim = useStore(state => state.dim);
	const setDim = useStore(state => state.setDim);
	const geo = useStore(state => state.geo);
	const remInPx = useStore(state => state.remInPx);

	useEffect(() => {
		// console.log('clicked Stories');
	}, [showStories]);
	
	// Function to handle closing the story and resetting dimensions
	const handleCloseStory = () => {
		setShowStories(false);
		setDim({
			...dim,
			right: {
				...dim.right,
				width: dim.screen.width * 0.4,
				height: dim.screen.height - dim.top.height
			}
		});
	};
	
	// Don't render anything if stories aren't meant to be shown
	if (!showStories) {
		return null;
	}
	
	return (
		<div className={styles.storyContainer} style={{visibility: showStories ? 'visible' : 'hidden'}}>
			<div className={styles.storyContent}>
				<div style={{...contentStyle.head}}>
					<h1 style={contentStyle.mainTitle}>
						Über eine "Black Box" des Barock: Das literarische Vermächtnis des Prinzen Eugen von Savoyen
					</h1>
					<img src="story/image0b.jpg" alt="Prinz Eugen Portrait" style={contentStyle.floatLeft}/>
				
				</div>
				<div style={contentStyle.textContainer}>
					
					{/* Initial comparison section */}
					<div style={contentStyle.section}>
						<p>
							Als im Jahre 1738 der Besitz des Prinzen Eugen von Savoyen kurz nach seinem Tod zum Verkauf
							kam,
							kam es zu einer erstaunlichen Einsicht bei der direkten Gegenüberstellung seines Vermögens:
							Das von ihm erbaute weitläufige Schloss Belvedere wurde mit 100.000 Gulden, seine barocke
							Büchersammlung von etwa 16.000 Büchern und Manuskripten - die sogenannte "Bibliotheca
							Eugeniana" -
							hingegen mit 150.000 Gulden geschätzt.
						</p>
					
					</div>
					
					<div style={contentStyle.sideBySide}>
						<div style={contentStyle.imageWithCaption}>
							<div style={contentStyle.sidebySideImage}>
								<img src="story/image1.png" alt="Schloss Belvedere"
								     style={{
									     width: '100%',
									     maxWidth: '600px',
									     height: 'auto'
								     }}
								/>
							</div>
							<div style={contentStyle.sideBySideCaption}>
								100.000 Gulden
							</div>
						</div>
						<div style={contentStyle.imageWithCaption}>
							<div style={contentStyle.sidebySideImage}>
								<img src="story/image2.png" alt="Bibliotheca Eugeniana"
								     style={{
									     width: '45%',
									     maxWidth: '400px',
									     height: 'auto'
								     }}
								/>
							</div>
							<div style={contentStyle.sideBySideCaption}>
								150.000 Gulden
							</div>
						</div>
					</div>
					
					<p style={contentStyle.caption}>
						Abb. 1: Schematische Gegenüberstellung der Schätzwerte von Schloss Belvedere
						(links) und Prinz
						Eugens Büchersammlung, der “Bibliotheca Eugeniana” (rechts, ONB).
					</p>
					
					{/* Black Box explanation */}
					<div style={contentStyle.section}>
						<p>
							Während das Schloss Belvedere den meisten WienerInnen (und vielen Touristen) vertraut ist,
							ist die Bibliotheca Eugeniana kaum jemandem ein Begriff. Aufgrund ihrer Größe und
							ihrer bewegten Geschichte, die von vielen Übersiedlungen und Umordnungen geprägt war,
							waren selbst Bibliothekarinnen bislang kaum in der Lage, ihren Umfang und inhaltlichen
							Aufbau zu bestimmen.
						</p>
						<p>
							Der Begriff "Black Box" bezeichnet in modernen Zeiten oft Dinge oder Systeme, deren innerer
							Aufbau nicht genau bekannt ist. (Man weiß nur, was hinein und herausgeht, aber wie es im
							Inneren funktioniert, bleibt verborgen.) In diesem Sinne war die Bibliotheca Eugeniana bis
							vor Kurzem auch für Fachleute und BesucherInnen kaum durchschaubar. Ein Forschungsprojekt
							beleuchtete vor diesem Hintergrund die historischen Ursprünge und aktuelle Aufstellung
							dieser
							wertvollen und einmaligen Sammlung (welche zum UNESCO Kulturerbe Österreichs zählt), um sie mit
							digitalen Methoden neu sichtbar zu machen.
						</p>
					</div>
					
					{/* Prince Eugene biography */}
					<div style={contentStyle.section}>
						<h2 style={contentStyle.sectionTitle}>Prinz Eugen - Ein Leben zwischen Krieg und Kunst</h2>
						<img src="story/image3.png" alt="Timeline" style={{...contentStyle.floatRight}}/>
						<p>
							Prinz Eugen von Savoyen, geboren 1663 in Paris, war einer der bedeutendsten Feldherren des
							18. Jahrhunderts und ein Held der habsburgischen Monarchie. Aufgrund seiner Ablehnung durch
							den
							französischen Hof floh er als junger Mann nach Wien, wo er seine militärische Laufbahn
							begann.
						</p>
						
						<p>
							Nach seiner Ausbildung an der Militärakademie trat er in den Dienst der Habsburger und
							erlangte
							erste Erfolge in den Türkenkriegen. Sein großer Triumph kam 1697 in der Schlacht von Zenta,
							wo er
							die Osmanen entscheidend schlug. Dies machte ihn zum gefeierten General, und er führte
							zahlreiche
							weitere siegreiche Feldzüge, darunter im Spanischen Erbfolgekrieg und im
							Venezianisch-Österreichischen
							Krieg.
						</p>
						
						<p>
							Neben seinen militärischen Leistungen war Eugen jedoch auch ein Mäzen der Künste. Er ließ
							prächtige
							Bauwerke wie das Belvedere in Wien errichten und sammelte wertvolle Kunstwerke und Bücher.
						</p>
						
						<p>
							Im Alter verlor er an politischem Einfluss, starb jedoch hochgeehrt 1736 in Wien im Alter
							von 73 Jahren.
						</p>
						
						<img src="story/image4.png" alt="Historical Map" style={contentStyle.fullWidthImage}/>
						<p style={contentStyle.caption}>
							Abb. 2: Prinz Eugen von Savoyen vor dem schematischen Umriss des
							Habsburgerreiches um 1736 (links)
							und
							historische Karte (rechts)
						</p>
					</div>
					
					{/* Bibliotheca Eugeniana */}
					<div style={contentStyle.section}>
						<h2 style={contentStyle.sectionTitle}>Die Bibliotheca Eugeniana</h2>
						<p>
							Während seine militärischen Erfolge in Österreich weit gerühmt wurden, ist heute weniger
							bekannt,
							dass Prinz Eugen ein ausgewiesener Kunstliebhaber war, der sehr viel Geld in die Sammlung
							der
							besten Bücher seiner Zeit steckte.
						</p>
						<img src="story/image5.png" alt="Muratori" style={contentStyle.floatRight}/>
						<div style={contentStyle.quote}>
							<p>
								„Wir wissen, wie Ihre Liebe zu den Wissenschaften beschaffen ist: Während Sie bei den
								Feldzügen mit der rechten Hand unbesiegt das Schwert führen, benützen Sie diese zu
								Hause zur Handhabung vortrefflicher Bücher. Wir haben von den Schätzen und kostbaren
								Büchern
								Ihrer berühmten Bibliothek gehört, in der Sie Werke aus allen Ländern zusammengetragen
								haben,
								würdig einem solch großen und erhabenen Fürsten der Bücher."
							</p>
							<p>- Muratori, 1723</p>
						</div>
						
						<p>
							<strong>Umfang und Sprache:</strong> Bis zu seinem Tod erwarb Eugen ca. 15.000 Drucke, 480
							Handschriften, 290 Bände mit
							Kupferstichen und 215 Kassetten mit Porträts. Ebenso wie in der Diplomatie, beauftragte
							er Agenten in Paris, Amsterdam und Venedig ihn über Neuerscheinungen und interessante
							Kaufoptionen zu informieren; auf diesem Wege kam er sogar zu Büchern aus Mexiko und Indien.
							Dennoch ist der Großteil der Bücher (knapp die Hälfte) in Eugens Muttersprache auf
							Französisch
							verfasst, ein Drittel auf Latein. Es finden sich nur sehr wenige deutschsprachige Exemplare
							in der
							Sammlung - was die oftmals geäußerten Zweifel an Eugens Deutschkenntnissen bestärkt.
						</p>
						<div style={{
							...contentStyle.fullWidthImage,
							position: 'relative'
						}}>
							{geo ? (  // Move condition to parent
								<>
									<GeoMap/>
									<InstructionOverlay
										offset={-5 * remInPx}
										text="Mit Zoom können Sie Details der Karte erkunden."/>
								</>
							
							) : (
								<div style={{
									width: '100%',
									height: '300px',
									display: 'flex',
									alignItems: 'center',
									justifyContent: 'center',
									background: '#f5f5f5'
								}}>
									Loading map data...
								</div>
							)}
						</div>
						<img src="story/image6.png" alt="Rousseau" style={contentStyle.floatRight}/>
						<div style={contentStyle.quote}>
							<p>
								„Eugens Bibliothek ist ziemlich groß und besteht aus vielen guten, schön gebundenen
								Büchern.
								Aber erstaunlich ist, dass es da fast kein Buch gibt, das der Prinz nicht gelesen oder
								wenigstens
								durchgeblättert hat, bevor er es zum Buchbinder schickt. Es ist kaum zu glauben, dass
								ein Mensch,
								der die Last fast aller Geschäfte Europas auf seinen Schultern trägt, oberster Feldherr
								des Reiches
								und erster Minister des Kaisers ist, so viel Zeit zum Lesen findet, als hätte er gar
								nichts anderes zu tun."
							</p>
							<p>- Jean-Baptiste Rousseau, 1716</p>
						</div>
						
						<p>
							<strong>Inhalte:</strong> Eugens sammlerische Tätigkeit war von "universaler" Ausrichtung
							mit Interesse für viele verschiedene Wissensfelder seiner Zeit. Seine Bibliothek umfasste
							daher Bücher der Geschichte ebenso wie jene der Poesie und der Naturwissenschaften.
							Die Sammlung stellt damit eine unschätzbare Quelle für ein Verständnis des
							wissenschaftlichen Erkenntnisstandes zur Zeit des Barock dar.
						</p>
						<img src="story/image7.png" alt="Historical Taxonomy" style={contentStyle.fullWidthImage}/>
						<p style={contentStyle.caption}>
							Abb. 3: Historischer Bibliothekskatalog (links), extrahierte
							Wissensklassen (Mitte) und
							Visualisierung der historischen Taxonomie gemäß der Anzahl von Büchern pro Wissensklasse
							(rechts).
						</p>
						
						<p>Hier können Sie die deutschsprachige Variante ausprobieren.
							Klicken Sie auf einen Kreis oder neben einen Kreis.</p>
						<div style={contentStyle.fullWidthImage}>
							<div style={{
								height: '100%',
								width: '100%',
								marginLeft: '7rem',
								position: 'relative'
							}}>
								<>
									<CirclePacking inStory={true}/>
									<InstructionOverlay offset={4 * remInPx}
									                    text="Klicken Sie auf einen Kreis um zu zoomen."/></>
							
							</div>
						</div>
						
						
						<p>
							In seinem Winterpalais in der Himmelpfortgasse (Wien) ließ Eugen einen eigenen Flügel für
							seine
							Bibliothek errichten, in dem seine Bücher nach Themen in drei Bibliothekssälen eingeordnet
							waren.
							Im hintersten davon gab es angeblich auch Regale mit "verbotenen Büchern", die hinter
							Gittern
							nicht offen zugänglich waren.
						</p>
						
						<img src="story/image8.png" alt="Buildings" style={contentStyle.fullWidthImage}/>
						<p style={contentStyle.caption}>
							Abb. 4: Der Großteil von Prinz Eugens Bibliothek war ursprünglich im
							Winterpalais in der
							Himmelpfortgasse 8 (links) untergebracht, sowie im Schloss Belvedere (rechts).
						</p>
						
						<p>
							Eugen beschäftigte einen eigenen Buchbinder, der die meisten Neuerwerbungen in rotem, wenige
							auch
							in gelbem oder blauem Leder einband und mit seinem persönlichen Wappen versah. Diese
							Einbände
							verleihen seiner Sammlung ein einheitliches Aussehen und einen hohen Wiedererkennungswert.
						</p>
						
						<img src="story/image9.jpg" alt="Library Room" style={contentStyle.fullWidthImage}/>
						<p style={contentStyle.caption}>
							Abb. 5: Bild eines Bibliotheksraums im Winterpalais nach Salomon Kleiner
							(BDA, Hervorhebung durch
							die Autoren)
							(links) und Grundrisszeichnung des gesamten Bibliothekstrakts (rechts) mit hypothetischer
							Rekonstruktion der Bücheranordnung (BED Team).
						</p>
					</div>
					
					{/* Prince Eugene's Legacy */}
					<div style={contentStyle.section}>
						<div style={contentStyle.section}>
							<h2 style={contentStyle.sectionTitle}>Das Erbe Prinz Eugens</h2>
							<p>
								Prinz Eugen hatte keine Kinder, sodass bei seinem Tod im Jahr 1736 sein gesamtes Erbe an
								seine
								Nichte Anna Viktoria von Savoyen (1683-1763) fiel. Um an Geld zu kommen, verkaufte
								diese nach
								und nach Eugens Vermögen, so auch seine Büchersammlung. Diese erwarb der damalige Kaiser
								Karl VI
								als Ganzes für seine Hofbibliothek und positionierte die schön gebundenen Bücher
								prominent im
								Mitteloval des neu erbauten Prunksaals.
							</p>
							
							<img src="story/image10.png" alt="Prunksaal History" style={contentStyle.fullWidthImage}/>
							<p style={contentStyle.caption}>Abb. 6: Geschichte des Prunksaals &
								Josefstrakts (Fischer von
								Erlach)</p>
							
							<p>
								Im Mitteloval des Prunksaals in der Nationalbibliothek können Sie auch heute noch große
								Teile der
								Bibliotheca Eugeniana finden. Im Zuge von Restaurierungen und Umstrukturierungen kam es
								jedoch im
								Verlauf von drei Jahrhunderten mehrfach zu Umstellungen, zur Ergänzung weiterer Bücher,
								aber auch
								zu Verkäufen von Duplikaten. Gleichzeitig sind im aktuellen Bibliothekskatalog nur
								wenige Bücher
								als Teil der Bibliotheca Eugeniana ausgewiesen.
							</p>
							
							<p>
								Daher setzte es sich das Projekt Bibliotheca Eugeniana Digital (BED) zum Ziel, diese
								Sammlung
								innerhalb der ÖNB zu rekonstruieren - und damit diese wertvolle Sammlung für Sie wieder
								zugänglich zu machen.
							</p>
							<p>
								Wir laden Sie daher nun ein, die Sammlung mittels der interaktiven Visualisierungen selbst zu erkunden.
							</p>
							
							<img src="story/image11.jpg" alt="Library Visualization"
							     style={contentStyle.fullWidthImage}/>
							<p style={contentStyle.caption}>
								Abb. 7: Visualisierung der Bibliotheca Eugeniana im Prunksaal
								(Mitte) mit Liste aller
								identifizierten
								Bücher (links) und analytischen Ansichten auf die Bibliothek (rechts).
							</p>
						</div>
					</div>
				</div>
			</div>
			
<div
                className={styles.Button}
                style={{width: 'max-content', marginLeft: '80%', marginRight: 'auto'}}
                onClick={handleCloseStory}
            >
                Story schließen
            </div>
            
            <div
                className={styles.close}
                onClick={handleCloseStory}
            >
                &#10006;
            </div>
            <br />
        </div>
    );
};

const InstructionOverlay = ({ text, offset = 0 }) => {
	return (
		<div style={{
			position: 'absolute',
			right: `${offset}px`,
			top: '50%',
			transform: 'translateY(-50%)',
			display: 'flex',
			alignItems: 'center',
			gap: '1rem',
			width: '10rem'
		}}>
			<div style={{
				width: '5rem',
				height: '2px',
				backgroundColor: '#000',
				position: 'relative'
			}}>
				<div style={{
					position: 'absolute',
					left: '-1px',  // Align with the end of the line
					top: '50%',
					width: 0,
					height: 0,
					transform: 'translateY(-50%)',  // Only transform Y
					borderTop: '6px solid transparent',
					borderBottom: '6px solid transparent',
					borderRight: '8px solid #000'
				}} />
			</div>
			<p style={{
				margin: 0,
				fontSize: '1.0rem',
				fontStyle: 'italic',
				lineHeight: '1.2'
			}}>
				{text}
			</p>
		</div>
	);
};
