import styles from "../styles.module.css";
import {useStore} from "../store.js";
import {useEffect} from "react";
import { CgSearch } from "react-icons/cg";

export const SearchFilter = () => {

	const search = useStore(state => state.search);
	const setSearch = useStore(state => state.setSearch);

	useEffect(()=>{
	}, [search])

	const handleSearch = (e) => {
		// console.log(e.target.value)
		let value = e.target.value
		setSearch(value)
	}

	return (
		<div className={styles.NavBarItemSearch}>
			<div className={styles.searchBox}>
			<CgSearch className={styles.searchIcon} size={'1.3em'} color={'#666666'} />
			<input
				className={styles.searchInput}
				onChange={handleSearch}
				value={search}
				placeholder={'Filter...'}
			/>
			</div>
		</div>

	)
}
