import {useEffect} from 'react';
import {useStore} from "../store.js";
import {useWindowDimensions} from "../lib/hooks.jsx";
import useScreenOrientation from 'react-hook-screen-orientation'

export const Screen = () => {

	const {height, width} = useWindowDimensions();
	const screenOrientation = useScreenOrientation()

	const layoutInitialized = useStore(state => state.layoutInitialized)
	const setLayoutInitialized = useStore(state => state.setLayoutInitialized)

	const setShowWelcome = useStore(state => state.setShowWelcome)

	const isIOS = useStore(state => state.isIOS)
	const setIsIOS = useStore(state => state.setIsIOS)

	const setIsFirefox = useStore(state => state.setIsFirefox)

	const IOSOrientation = useStore(state => state.IOSOrientation)
	const setIOSOrientation = useStore(state => state.setIOSOrientation)

	const setIsTouch = useStore(state => state.setIsTouch)

	const setIsPrimaryTouch = useStore(state => state.setIsPrimaryTouch)

	const setIsHybridTouch = useStore(state => state.setIsHybridTouch)

	const setMobile = useStore(state => state.setMobile)

	const setPortrait = useStore(state => state.setPortrait)
	const setLandscape = useStore(state => state.setLandscape)

	const setMobileHeight = useStore(state => state.setMobileHeight)
	const mobileWidth = useStore(state => state.mobileWidth)
	const setMobileWidth = useStore(state => state.setMobileWidth)

	const iOS = () => {
		return [
				'iPad Simulator',
				'iPhone Simulator',
				'iPod Simulator',
				'iPad',
				'iPhone',
				'iPod'
			].includes(navigator.platform)
			// iPad on iOS 13 detection
			|| (navigator.userAgent.includes("Mac") && "ontouchend" in document)
	}

	const firefox = () => { return navigator.userAgent.toLowerCase().includes('firefox'); };

	useEffect(() => {

//		console.log('----------------------------')
//		console.log('resized', width, height)
//		console.log('screen (o/w/h)', screenOrientation, screenWidth, screenHeight)
//		console.log('avail (w/h)', window.innerWidth, window.innerHeight)
//		console.log('window', window)
//		console.log('mobile: ', mobile)
//		console.log('portrait: ', portrait)
//		console.log('landscape: ', landscape)
//		console.log('mobileHeight: ', mobileHeight)
//		console.log('mobileWidth: ', mobileWidth)
//		console.log('isFirefox: ', firefox())
//		console.log('iOS: ', iOS())
//		console.log('isIOS: ', isIOS)
//		console.log('IOSOrientation: ', IOSOrientation)
//		console.log('----------------------------')

		if(window.matchMedia("(pointer: coarse)").matches) {
			setIsPrimaryTouch(true)
		}

		if(window.matchMedia("(any-pointer: coarse)").matches) {
			setIsHybridTouch(true)
		}

		if (('ontouchstart' in window) || (navigator.msMaxTouchPoints > 0)) {
			setIsTouch(true)
		}

		if (iOS()) {
			setIsIOS(true)
		}
		if (firefox()) {
			setIsFirefox(true)
		}

		var currMobile = false

		if (window.screen.width < window.screen.height && window.screen.width < 480) {
			setMobile(true)
			currMobile = true
		} else if (window.screen.width > window.screen.height && window.screen.height < 480) {
			setMobile(true)
			currMobile = true
		} else {
			setMobile(false)
			currMobile = false
		}

		if (currMobile) {
			setShowWelcome(true)
		}

		if (!iOS() && screenOrientation === 'portrait-primary') {
			setPortrait(true)
			setLandscape(false)
			if (!layoutInitialized) {
				setShowWelcome(currMobile ? true : false)
				setLayoutInitialized(true)
			}
		}

		if (!iOS() && screenOrientation === 'landscape-primary') {
			setPortrait(false)
			setLandscape(true)
		}

		if (iOS()) {
			const IOSportrait = window.matchMedia("(orientation: portrait)").matches;
			let h = window.innerHeight
			let w = window.innerWidth

			// do this only once on startup
			if (!layoutInitialized) {
				setMobileWidth(IOSportrait ? w : h)
				setMobileHeight(IOSportrait ? h : w)
				setShowWelcome(currMobile ? true : false)
				setLayoutInitialized(true)
			}
			setIOSOrientation(IOSportrait ? 'portrait' : 'landscape')
			setPortrait(IOSportrait ? true : false)
			setLandscape(IOSportrait ? false : true)
		}

		return
	}, [height, width, screenOrientation, IOSOrientation, isIOS, mobileWidth]);

	useEffect(() => {
		//console.log('.......... check for listener')
		try{
			window.matchMedia("(orientation: portrait)")
				.addEventListener("change", e => {
					//console.log('............. listener changed')
					const portrait = e.matches;
					if (portrait) {
						setPortrait(true)
						setLandscape(false)
						setIOSOrientation('portrait')
					} else {
						setPortrait(false)
						setLandscape(true)
						setIOSOrientation('landscape')
					}
				});
		} catch {
			//console.log('old safari, no listener')
		}

	}, [isIOS]);

	return (<></>)

}
