import {useStore} from "../store.js";
import {useEffect, useState} from "react";
import styles from "../styles.module.css";
import {VscFilter} from "react-icons/vsc";
import {Legend} from "./Legend.jsx";

export const Places = () => {

	const storedPlaces = useStore(state => state.storedPlaces);

	const dim = useStore(state => state.dim);
	const mode = useStore(state => state.mode);
	const legend = useStore(state => state.legend);

	const hoveredPlace = useStore(state => state.hoveredPlace);
	const setHoveredPlace = useStore(state => state.setHoveredPlace);

	const filterPlace = useStore(state => state.filterPlace);
	const setFilterPlace = useStore(state => state.setFilterPlace);

	const [selectedPlace, setSelectedPlace] = useState();

	const [maxSize, setMaxSize] = useState(0)
	const [more, setMore] = useState(false)
	const [data, setData] = useState(false)
	const [factor, setFactor] = useState(false)

	useEffect(() => {
	}, [mode]);

	useEffect(()=>{

		if (!storedPlaces) return

		const max = storedPlaces.topTen.reduce(function(prev, current) {
			return (prev && prev.cnt > current.cnt) ? prev : current
		})

		let radius = 0.007

		let newFactor = dim.right.height/1100*radius;
		setFactor(newFactor);

		setMaxSize(max.cnt*newFactor)
		setData(more ? storedPlaces.placesList : storedPlaces.topTen)

	}, [storedPlaces, more, dim, data])

	useEffect(() => {
		if (!hoveredPlace && !selectedPlace) {
			setFilterPlace(false)
		}
		else if (selectedPlace) {
			setFilterPlace(selectedPlace)
		}

	}, [hoveredPlace, setFilterPlace]);

	useEffect(() => {
		if (!filterPlace) {
			setSelectedPlace(false)
		}
	}, [filterPlace]);


	useEffect(()=>{
		setFilterPlace(selectedPlace)
	}, [selectedPlace, setFilterPlace])

	if (!data) return;
	return (
		<>
			{mode === "colors" &&
				<Legend dataset={"colors"}
				        style={{marginLeft: '4rem', justifyContent: 'flex-start', fontSize: '0.8rem', padding: '1rem', paddingBottom: '1rem', flexWrap:'wrap'}}/>
			}
			{mode === "memberships" &&
				<Legend dataset={legend.memberships} style={{marginLeft: '2.5rem', justifyContent: 'flex-end', fontSize: '0.8rem', padding: '1rem'}}/>
			}
		<div className={styles.overlayContainerScroll} style={{

		}}>
			<div className={styles.Button} onClick={()=>setMore(!more)}
			     style={{position: 'absolute', bottom: '3em', right: '3em'}}>
				{more ? 'Top10' : 'mehr'}
			</div>
			<div>
			{ data.map((d, i) => {
				return <div key={'places'+i}
				    style={{
						background: hoveredPlace === d.name ? '#dddddd66' : 'none',
					    fontWeight: hoveredPlace === d.name ? 600 : 400,
					    display: 'flex', flexDirection: 'row', justifyContent: 'space-between',
					    border: selectedPlace === d.name ? '1px solid black' : null,
					    paddingLeft: '5px',
					    borderRadius: '0.5rem',
					    cursor: (!filterPlace || filterPlace === d.name ) ? "pointer" : "default",
				}}
					onMouseEnter={()=> {setHoveredPlace(!selectedPlace ? d.name : false); if (!selectedPlace) setFilterPlace(d.name) }}
					onMouseLeave={()=> {setHoveredPlace(false);}}
					onClick={()=> {setSelectedPlace(selectedPlace != d.name ? d.name : false)}}
				>
					<div style={{width: '2rem', paddingLeft: '0.2rem', alignSelf: 'center'}}>
						{selectedPlace === d.name ? <VscFilter className={styles.reactIcons} size={'1.2em'}/> : ''}
					</div>
					<div style={{width: '10vw', paddingLeft: '0em', flex: 1, alignSelf: 'center'}}>{d.name} </div>
					<div style={{paddingLeft: '0em', flex: 1, alignSelf: 'center'}}>{d.cnt}</div>
					<div style={{marginRight: '2em', width: maxSize*2, height: maxSize*2, alignSelf: 'center'}}>
						<svg className={styles.svgDiv} width={'100%'} height={'100%'}
						     style={{background: hoveredPlace === d.name ? '#dddddd66' : 'none'
						}}>
							<circle
								cx={maxSize*1}
								cy={maxSize*1}
								r={d.cnt*factor}
								fill={'#A38564'}
							>
							</circle>
						</svg>
					</div>
				</div>
			})}
			</div>
		</div>
		</>
	)
}
