/* eslint-disable react/prop-types */
import styles from "../styles.module.css";
import React, {useRef, useState, useEffect} from 'react';

import {useStore} from "../store";
import {scaleLinear} from "d3";

import {sortBySignature} from "../lib/sorting.jsx";

export const EmptyBookshelf = (props) => {
	const {width, height, side, shelves, highlight} = props;
	
	const currentShelf = useStore(state => state.currentShelf);
	const setCurrentShelf = useStore(state => state.setCurrentShelf);
	const setHoveredBook = useStore(state => state.setHoveredBook)
	const hoverShelf = useStore(state => state.hoverShelf)
	const setHoverShelf = useStore(state => state.setHoverShelf)
	const setHoveredSection = useStore(state => state.setHoveredSection);
	const setHoldHoveredSection = useStore(state => state.setHoldHoveredSection);
	const storedSubCats = useStore(state => state.storedSubCats);
	const [shelfedData, setShelfedData] = useState(false);
	
	const nightMode = useStore(state => state.nightMode);
	const setNightmode = useStore(state => state.setNightMode);
	const [background, setBackground] = useState();
	useEffect(() => {
		setBackground(nightMode ? '#666' : 'var(--background)')
	}, [nightMode]);
	
	const halfWidth = width / 2;
	const halfHeight = height / 2;
	
	const radiusHeight = side * 0.1;
	const radiusTop = side * 0.08;
	
	const shelvesList = useStore.getState().shelvesList;
	const sections = useStore.getState().sections;
	
	const setSelectedBook = useStore(state => state.setSelectedBook)
	const setShowShelfHint = useStore(state => state.setShowShelfHint);
	const showHighlights = useStore(state => state.showHighlights);
	
	useEffect(() => {
		if (!currentShelf) setSelectedBook(false)
	}, [currentShelf, setSelectedBook]);
	
	useEffect(() => {
		
		if (!storedSubCats) return
		
		var newPool = [];
		
		shelvesList.map((shelf) => {
			var newData = [];
			sections.map((section) => {
				const sec = storedSubCats.all[shelf + '.'].filter((book) => book.Signatur.startsWith(`${shelf}.${section}.`))
				newData[section] = sec
			})
			newPool[shelf] = newData;
		})
		
		setShelfedData(newPool)
		
	}, [storedSubCats]);
	
	const xscale = scaleLinear([0, 100], [halfWidth - radiusTop, halfWidth + radiusTop]);
	const yscale = scaleLinear([0, 100], [halfHeight - radiusHeight, halfHeight + radiusHeight]);
	
	const scale = (x, y, skewFactor = 0.1) => {
		const skewed = scaleLinear([0, 100], [skewFactor * (y / 100), -skewFactor * (y / 100)]);
		return [xscale(x + (100 * skewed(x))), yscale(y)];
	}
	
	if (!shelfedData) {
		return (<></>)
	} else
		return (
			<>
				{shelvesList.map((shelfItem) => {
						const shelf = shelves[shelfItem]
						return (
							<g
								key={'shelf-placement-container' + shelf.id}
								className={styles.bookshelfBox}
								transform={shelf.transform}
								onMouseEnter={() => {
									setHoverShelf(`${shelf.id}.`);
									setHoveredSection(false)
									setHoldHoveredSection(false)
									setHoveredBook(false)
								}}
								onMouseLeave={() => {
									setHoverShelf(null);
									setHoveredSection(false)
									setHoldHoveredSection(false)
								}}
								onClick={() => {
									if (showHighlights) return;
									setCurrentShelf(currentShelf !== `${shelf.id}.` ? `${shelf.id}.` : false)
									setShowShelfHint(false);
								}}>
								
								<polygon
									points={
										scale(0, 0).toString() + ', ' +
										scale(100, 0).toString() + ', ' +
										scale(100, 100).toString() + ', ' +
										scale(0, 100).toString()
									}
									strokeWidth={side * 0.004}
									fill={hoverShelf === `${shelf.id}.` ? '#fff' : background}
									className={styles.overviewBookshelf}
									stroke={showHighlights && shelf.id === `BE.${highlight.shelf}` ? 'var(--highlightSelected)' : `${shelf.id}.` === currentShelf ? 'var(--ovalLinesSelected)' : 'var(--ovalBorders)'}
								/>
								
								<text
									transform={`translate(0, ${-side * 0.02})`}
									x={halfWidth}
									y={halfHeight - side * 0.1}
									className={styles.ovalTitle}
									textAnchor='middle'
									filter="url(#whiteOutlineEffect)"
									fontSize={hoverShelf === `${shelf.id}.` ? side * 0.025 : side * 0.018}
								>
									<tspan alignmentBaseline='before-edge'>
										{shelf.label}
									</tspan>
								</text>
							</g>)
					}
				)
				}
			</>
		)
}

export const PlacementBookshelf = React.memo((props) => {
	
	const {width, height, side} = props;
	
	const shelvesList = useStore.getState().shelvesList;
	const sections = useStore.getState().sections;
	const ZZsections = useStore.getState().ZZsections;
	
	const mode = useStore(state => state.mode);
	
	const hoveredPlace = useStore(state => state.hoveredPlace);
	const filterPlace = useStore(state => state.filterPlace);
	const hoveredColor = useStore(state => state.hoveredColor);
	
	const chartType = useStore(state => state.chartType);
	const filterTimerange = useStore(state => state.filterTimerange);
	const hoveredMember = useStore(state => state.hoveredMember);
	const hoveredTaxonomy = useStore(state => state.hoveredTaxonomy);
	const filterTaxonomy = useStore(state => state.filterTaxonomy);
	const hoveredLanguage = useStore(state => state.hoveredLanguage);
	const filterLanguage = useStore(state => state.filterLanguage);
	const selectedLegend = useStore(state => state.selectedLegend);
	
	const [shelfedData, setShelfedData] = useState(false);
	
	const storedSubCats = useStore(state => state.storedSubCats);
	
	const sortSection = useStore(state => state.sortSection)
	
	const nightMode = useStore(state => state.nightMode);
	const setNightmode = useStore(state => state.setNightMode);
	const [background, setBackground] = useState();
	useEffect(() => {
		setBackground(nightMode ? '#666' : 'var(--background)')
	}, [nightMode]);
	
	const shelves = {
		"BE.1": {
			id: "BE.1",
			isOval: true,
			label: "BE 1",
			transform: `rotate(-65.5) translate(0 ${-side / 2 * 0.775}) rotate(-9)`
		},
		"BE.2": {
			id: "BE.2",
			isOval: true,
			label: "BE 2",
			transform: `rotate(-42) translate(0 ${-side / 2 * 0.85}) rotate(-14)`
		},
		"BE.3": {
			id: "BE.3",
			isOval: true,
			label: "BE 3",
			transform: `rotate(-21) translate(0 ${-side / 2 * 0.94}) rotate(-17)`
		},
		"BE.4": {
			id: "BE.4",
			isOval: true,
			label: "BE 4",
			transform: `rotate(21) translate(0 ${-side / 2 * 0.94}) rotate(17)`
		},
		"BE.5": {
			id: "BE.5",
			isOval: true,
			label: "BE 5",
			transform: `rotate(42) translate(0 ${-side / 2 * 0.85}) rotate(14)`
		},
		"BE.6": {
			id: "BE.6",
			isOval: true,
			label: "BE 6",
			transform: `rotate(65.5) translate(0 ${-side / 2 * 0.775}) rotate(9)`
		},
		"BE.7": {
			id: "BE.7",
			isOval: true,
			label: "BE 7",
			transform: `rotate(-65.5) translate(0 ${-side / 2 * -0.775}) rotate(-9) rotate(180)`
		},
		"BE.8": {
			id: "BE.8",
			isOval: true,
			label: "BE 8",
			transform: `rotate(-42) translate(0 ${-side / 2 * -0.85}) rotate(-14) rotate(180)`
		},
		"BE.9": {
			id: "BE.9",
			isOval: true,
			label: "BE 9",
			transform: `rotate(-21) translate(0 ${-side / 2 * -0.94}) rotate(-17) rotate(180)`
		},
		"BE.10": {
			id: "BE.10",
			isOval: true,
			label: "BE 10",
			transform: `rotate(21) translate(0 ${-side / 2 * -0.94}) rotate(17) rotate(180)`
		},
		"BE.11": {
			id: "BE.11",
			isOval: true,
			label: "BE 11",
			transform: `rotate(42) translate(0 ${-side / 2 * -0.85}) rotate(14) rotate(180)`
		},
		"BE.12": {
			id: "BE.12",
			isOval: true,
			label: "BE 12",
			transform: `rotate(65.5) translate(0 ${-side / 2 * -0.775}) rotate(9) rotate(180)`
		}
	}
	
	const halfWidth = width / 2;
	const halfHeight = height / 2;
	
	const radiusHeight = side * 0.1;
	const radiusTop = side * 0.08;
	
	const colors = useStore.getState().colors;
	
	const xscale = scaleLinear([0, 100], [halfWidth - radiusTop, halfWidth + radiusTop]);
	const yscale = scaleLinear([0, 100], [halfHeight - radiusHeight, halfHeight + radiusHeight]);
	
	const scale = (x, y, skewFactor = 0.1) => {
		const skewed = scaleLinear([0, 100], [skewFactor * (y / 100), -skewFactor * (y / 100)]);
		return [xscale(x + (100 * skewed(x))), yscale(y)];
	}
	
	useEffect(() => {
		
		if (!storedSubCats) return
		
		var newPool = [];
		
		shelvesList.map((shelf) => {
			var newData = [];
			ZZsections.map((section) => {
				const sec = storedSubCats.all[shelf + '.'].filter((book) => book.Shelf === `${shelf}.` && book.Section === `${section}`)
				if (sortSection === "date") {
					newData[section] = sec
				} else {
					newData[section] = sortBySignature(sec)
				}
			})
			newPool[shelf] = newData;
		})
		
		setShelfedData(newPool)
		
	}, [storedSubCats, sortSection]);
	
	const inTimerange = (book) => {
		
		var isMember = true;
		if (selectedLegend && mode === 'memberships') {
			isMember = hoveredMember.value === book.membership ? true : false;
		}
		if (selectedLegend && mode === 'colors') {
			//			console.log(hoveredColor, book, colors)
			isMember = (book.Farbklassifizierung !== "" && hoveredColor.subid === book.Farbklassifizierung) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "uncertain" && book.membership === 2) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "noneugeniana" && book.membership === 0)
				? true : false;
		}
		return isMember && filterTimerange && filterTimerange.x0 <= book['Anfang Veröffentlichungsdatum'] && filterTimerange.x1 >= book['Anfang Veröffentlichungsdatum'] ? true : false;
	}
	
	
	const checkSelected = (book) => {
		
		var isMember = true;
		if (selectedLegend && mode === 'memberships') {
			isMember = hoveredMember.value === book.membership ? true : false;
		}
		if (selectedLegend && mode === 'colors') {
			isMember = (book.Farbklassifizierung !== "" && hoveredColor.subid === book.Farbklassifizierung) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "uncertain" && book.membership === 2) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "noneugeniana" && book.membership === 0)
				? true : false;
		}
		
		if (chartType === "time") {
			return inTimerange(book)
		} else if (chartType === "geo" || chartType === "geomap") {
			if (hoveredPlace && !filterPlace) {
				return book['Orte_corr'].includes(hoveredPlace) && isMember ? true : false
			} else if (filterPlace) {
				return book['Orte_corr'].includes(filterPlace) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "language") {
			if (hoveredLanguage) {
				return book['Sprache'].includes(hoveredLanguage) && isMember ? true : false
			} else if (filterLanguage) {
				return book['Sprache'].includes(filterLanguage) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "member") {
			return !hoveredMember || book['membership'] === hoveredMember.value ? true : false
		} else if (chartType === "taxonomy" || chartType === "taxonomyCircle") {
			if (hoveredTaxonomy.name === "root") return isMember ? true : false;
			if (hoveredTaxonomy) {
				return (book['Wissensklasse'] === hoveredTaxonomy.name || book['Wissensunterklasse'] === hoveredTaxonomy.name) && isMember ? true : false
			} else if (filterTaxonomy) {
				return (book['Wissensklasse'] === filterTaxonomy.name || book['Wissensunterklasse'] === filterTaxonomy.name) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "color") {
			let visible = false
			if (hoveredColor && book['Farbklassifizierung'] === hoveredColor.subid) visible = true;
			else if (hoveredColor && hoveredColor.id === "uncertain" && book['Farbklassifizierung'] === "" && book['membership'] === 2) visible = true;
			else if (hoveredColor && hoveredColor.id === "noneugeniana" && book['Farbklassifizierung'] === "" && book['membership'] === 0) visible = true;
			return !hoveredColor || visible
		}
	}
	
	const getColor = (book) => {
		
		if (mode === "memberships") {
			return book.membership ? colors.membership[book.membership] : book.membership == 2 ? 'white' : colors.membership[0]
		}
		if (mode === "colors") {
			return book.Farbklassifizierung ? colors.Farbklassifizierung[book.Farbklassifizierung] : book.membership == 2 ? 'white' : colors.membership[0]
		}
		return 'blue'
	}
	
	
	return (<>
			{shelfedData && shelvesList.map((shelf, shelfIndex) => {
				
				let currentdata = shelfedData[shelf]
				let currentMeta = shelves[shelf]
				
				return (
					<g
						className={styles.bookshelfBoxClickthrough}
						key={'shelf-placement' + shelfIndex}
						transform={currentMeta.transform}
					>
						{ZZsections.map((row, index) => {
							const sectionLength = currentdata[row].length
							const bookSize = sectionLength < 1 ? sectionLength / 100 : sectionLength < 100 ? 100 / sectionLength : sectionLength / 100
							
							return (
								<g
									key={`section-${shelf}-${index}`}
									id={`section-${shelfIndex}-${index}`}
									className={styles.bookshelfBoxClickthrough}
									transform={"scale(0.9) translate(0, 1)"}
								>
									{currentdata[row].map((book, bookIndex) => {
											let perc = 5 + bookIndex / sectionLength * 100 * 0.9;
											let perc1 = 0 + perc / 2;
											let perc2 = 50 + perc / 2;
											let i = index % 2 ? index : index + 1
											
											return (
												<rect
													key={`book-${shelf.id}-${index}-${bookIndex}`}
													id={`book-${shelfIndex}-${index}-${bookIndex}`}
													x={scale(index % 2 ? perc2 : perc1, (sections.length - i) * 3.8, 0.09)[0]}
													y={scale(index % 2 ? perc2 : perc1, (sections.length - i) * 3.8, 0.09)[1]}
													width={sectionLength < 1 ? bookSize * 0.4 * side * 0.002 : bookSize * 0.5 * side * 0.0012}
													height={side * 0.012}
													fill={getColor(book)}
													fillOpacity={checkSelected(book) ? 1 : 0.2}
												></rect>
											)
										}
									)}
									<circle
										className={'sectionIndicator'}
										id={`markercircle-${shelfIndex}-${index}`}
										cx={0}
										cy={0}
										r={5}
										fill={'purple'}
									>
									</circle>
								</g>
							)
						})}
						<use href=".sectionIndicator"/>
					</g>
				)
			})}
		</>
	)
})

export const PlacementBookshelfSingle = React.memo((props) => {
	
	const {width, height, side} = props;
	
	const sections = useStore.getState().sections;
	const ZZsections = useStore.getState().ZZsections;
	
	const hoveredBook = useStore(state => state.hoveredBook);
	const setHoveredBook = useStore(state => state.setHoveredBook);
	
	const hoveredColor = useStore(state => state.hoveredColor);
	const hoveredPlace = useStore(state => state.hoveredPlace);
	const chartType = useStore(state => state.chartType);
	const filterTimerange = useStore(state => state.filterTimerange);
	const filterPlace = useStore(state => state.filterPlace);
	const hoveredMember = useStore(state => state.hoveredMember);
	const hoveredTaxonomy = useStore(state => state.hoveredTaxonomy);
	const filterTaxonomy = useStore(state => state.filterTaxonomy);
	const hoveredLanguage = useStore(state => state.hoveredLanguage);
	const filterLanguage = useStore(state => state.filterLanguage);
	const selectedLegend = useStore(state => state.selectedLegend);
	const mode = useStore(state => state.mode);
	const selectedBook = useStore(state => state.selectedBook);
	const storedSubCats = useStore(state => state.storedSubCats);
	const currentShelf = useStore(state => state.currentShelf);
	
	const hoveredSection = useStore(state => state.hoveredSection);
	const setHoveredSection = useStore(state => state.setHoveredSection);
	const sortSection = useStore(state => state.sortSection)
	
	const [shelfedData, setShelfedData] = useState(false);
	const [hover, setHover] = useState(false)
	const [clicked, setClicked] = useState(false)
	
	const nightMode = useStore(state => state.nightMode);
	const setNightmode = useStore(state => state.setNightMode);
	const [background, setBackground] = useState();
	useEffect(() => {
		setBackground(nightMode ? '#666' : 'var(--background)')
	}, [nightMode]);
	
	const SVGref = useRef();
	
	const halfWidth = width / 2;
	const halfHeight = height / 2;
	
	const radiusHeight = side * 0.1;
	const radiusTop = side * 0.08;
	
	const colors = useStore.getState().colors;
	
	const xscale = scaleLinear([0, 100], [halfWidth - radiusTop, halfWidth + radiusTop]);
	const yscale = scaleLinear([0, 100], [halfHeight - radiusHeight, halfHeight + radiusHeight]);
	
	const scale = (x, y, skewFactor = 0.01) => {
		const skewed = scaleLinear([0, 100], [skewFactor * (y / 100), -skewFactor * (y / 100)]);
		return [xscale(x + (100 * skewed(x))), yscale(y)];
	}
	
	useEffect(() => {
	}, [hoveredSection])
	
	useEffect(() => {
		if (!selectedBook) setClicked(false);
	}, [selectedBook]);
	
	useEffect(() => {
	}, [clicked]);
	
	useEffect(() => {
		
		if (!storedSubCats) return
		
		if (!currentShelf) {
			setShelfedData(false)
			return
		}
		
		var newData = [];
		ZZsections.map((section) => {
			const sec = storedSubCats.all[currentShelf].filter((book) => book.Shelf === currentShelf && book.Section === section)
			newData[section] = sec
		})
		
		setShelfedData(newData)
		
	}, [storedSubCats, currentShelf, sortSection, ZZsections]);
	
	// todo: check if still needed
	const onMouseMove = (e) => {
		let rect = e.currentTarget.getBoundingClientRect();
		let x = e.clientX - rect.left;
		
		if (SVGref.current) {
			let boxcoords = -50 + x / 10 + " 200 350 250"
			SVGref.current.setAttribute("viewBox", boxcoords);
		}
	};
	
	const inTimerange = (book) => {
		
		var isMember = true;
		if (selectedLegend && mode === 'memberships') {
			isMember = hoveredMember.value === book.membership ? true : false;
		}
		if (selectedLegend && mode === 'colors') {
			isMember = (book.Farbklassifizierung !== "" && hoveredColor.subid === book.Farbklassifizierung) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "uncertain" && book.membership === 2) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "noneugeniana" && book.membership === 0)
				? true : false;
		}
		return isMember && filterTimerange && filterTimerange.x0 <= book['Anfang Veröffentlichungsdatum'] && filterTimerange.x1 >= book['Anfang Veröffentlichungsdatum'] ? true : false;
	}
	
	
	const checkSelected = (book) => {
		
		var isMember = true;
		if (selectedLegend && mode === 'memberships') {
			isMember = hoveredMember.value === book.membership ? true : false;
		}
		
		if (selectedLegend && mode === 'colors') {
			isMember = (book.Farbklassifizierung !== "" && hoveredColor.subid === book.Farbklassifizierung) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "uncertain" && book.membership === 2) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "noneugeniana" && book.membership === 0)
				? true : false;
		}
		
		if (chartType === "time") {
			return inTimerange(book)
		} else if (chartType === "geo" || chartType === "geomap") {
			if (hoveredPlace && !filterPlace) {
				return book['Orte_corr'].includes(hoveredPlace) && isMember ? true : false
			} else if (filterPlace) {
				return book['Orte_corr'].includes(filterPlace) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "language") {
			if (hoveredLanguage) {
				return book['Sprache'].includes(hoveredLanguage) && isMember ? true : false
			} else if (filterLanguage) {
				return book['Sprache'].includes(filterLanguage) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "member") {
			return !hoveredMember || book['membership'] === hoveredMember.value ? true : false
		} else if (chartType === "taxonomy" || chartType === "taxonomyCircle") {
			if (hoveredTaxonomy.name === "root") return isMember ? true : false;
			if (hoveredTaxonomy) {
				return (book['Wissensklasse'] === hoveredTaxonomy.name || book['Wissensunterklasse'] === hoveredTaxonomy.name) && isMember ? true : false
			} else if (filterTaxonomy) {
				return (book['Wissensklasse'] === filterTaxonomy.name || book['Wissensunterklasse'] === filterTaxonomy.name) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "color") {
			let visible = false
			if (hoveredColor && book['Farbklassifizierung'] === hoveredColor.subid) visible = true;
			else if (hoveredColor && hoveredColor.id === "uncertain" && book['Farbklassifizierung'] === "" && book['membership'] === 2) visible = true;
			else if (hoveredColor && hoveredColor.id === "noneugeniana" && book['Farbklassifizierung'] === "" && book['membership'] === 0) visible = true;
			return !hoveredColor || visible
		}
	}
	
	const getColor = (book) => {
		if (mode === "memberships") {
			return book.membership ? colors.membership[book.membership] : book.membership == 2 ? 'white' : colors.membership[0]
		}
		if (mode === "colors") {
			return book.Farbklassifizierung ? colors.Farbklassifizierung[book.Farbklassifizierung] : book.membership == 2 ? 'white' : colors.membership[0]
		}
		return 'blue'
	}
	
	if (!shelfedData) return <></>
	return (<>
			<g
				className={styles.bookshelfBox}
				onClick={() => !hover ? setClicked(false) : null}
				transform={"scale(2.4) translate(0, 0)"}
			>
				<rect
					x={scale(0, 0)[0]}
					y={scale(0, 0)[1]}
					width={side * 0.16}
					height={side * 0.2}
					fill={background}
					stroke={'var(--ovalBorders)'}
					strokeWidth={0.5}
				>
				</rect>
				
				{ZZsections.map((row, index) => {
					const sectionLength = shelfedData[row].length
					const bookSize = sectionLength < 1 ? sectionLength / 100 : sectionLength < 100 ? 100 / sectionLength : sectionLength / 100
					return (
						<g
							key={`section-${index}`}
							className={styles.bookshelfBox}
							transform={'scale(1, 0.95) translate(0,2)'}
							onMouseEnter={() => {setHoveredSection("section" + index);}}
							
							onMouseMove={onMouseMove}
						>
							{shelfedData[row].map((book, bookIndex) => {
									let perc = 5 + bookIndex / sectionLength * 100 * 0.9;
									let perc1 = 0 + perc / 2;
									let perc2 = 50 + perc / 2;
									
									let i = index % 2 ? index : index + 1
									
									return (
										<g
											key={`stacked-book-${index}-${bookIndex}`}
											onClick={() => {
												setClicked(clicked === book ? false : book)
											}}
											onMouseEnter={() => {
												setHover(book);
												setHoveredBook(book)
											}}
											onMouseLeave={() => {
												setHover(false);
												setHoveredBook(false)
											}}
										>
											<rect
												key={`stacked-bar-${index}-${bookIndex}`}
												x={scale(index % 2 ? perc2 : perc1, (sections.length - i) * 3.8, 0.0)[0]}
												y={scale(index % 2 ? perc2 : perc1, (sections.length - i) * 3.8, 0.0)[1]}
												width={sectionLength < 1 ? bookSize * 0.4 * side * 0.002 : bookSize * 0.5 * side * 0.0014}
												height={side * 0.012}
												fill={
													(hover === book || hoveredBook === book) ? 'purple'
														:
														selectedBook === book ? 'black' : getColor(book)
												}
												
												fillOpacity={checkSelected(book) || (hover === book || hoveredBook === book) ? 1 : 0.2}
											
											></rect>
											{hoveredBook === book && !hoveredSection &&
												<circle
													id={'indicator'}
													cx={scale(index % 2 ? perc2 + bookSize * 0.18 : perc1 + bookSize * 0.18, (sections.length - i) * 3.8, 0.0)[0]}
													cy={scale(index % 2 ? perc2 + bookSize * 0.18 : perc1 + bookSize * 0.18, (sections.length - i) * 3.8, 0.0)[1]}
													r={1}
													fill={'purple'}
												>
												</circle>
											}
										</g>
									)
								}
							)}
							{
								<rect
									className={'section'}
									x={scale(index % 2 ? 52 : 2, (sections.length - (index % 2 ? index : index + 1)) * 3.8, 0)[0]}
									y={scale(index % 2 ? 52 : 2, (sections.length - (index % 2 ? index : index + 1)) * 3.8, 0)[1]}
									width={side * 0.072}
									height={side * 0.012}
									fill={'blue'}
									opacity={0.0}
								></rect>
							}
							<use href="#indicator"/>
							<use href=".section"/>
						
						</g>
					)
				})}
			</g>
		</>
	)
})

export const PlacementBookshelfSingleSection = React.memo((props) => {
	
	const {width, height, side} = props;
	
	const SVGref = useRef();
	const rectRef = useRef();
	
	const hoveredColor = useStore(state => state.hoveredColor);
	const hoveredPlace = useStore(state => state.hoveredPlace);
	const chartType = useStore(state => state.chartType);
	const filterTimerange = useStore(state => state.filterTimerange);
	const filterPlace = useStore(state => state.filterPlace);
	const hoveredMember = useStore(state => state.hoveredMember);
	const hoveredTaxonomy = useStore(state => state.hoveredTaxonomy);
	const filterTaxonomy = useStore(state => state.filterTaxonmy);
	const hoveredLanguage = useStore(state => state.hoveredLanguage);
	const filterLanguage = useStore(state => state.filterTaxonmy);
	const selectedLegend = useStore(state => state.selectedLegend);
	
	const ZZsections = useStore.getState().ZZsections;
	
	const mode = useStore(state => state.mode);
	
	const hoveredBook = useStore(state => state.hoveredBook);
	const setHoveredBook = useStore(state => state.setHoveredBook);
	const hoveredSection = useStore(state => state.hoveredSection);
	const setHoveredSection = useStore(state => state.setHoveredSection);
	const holdHoveredSection = useStore(state => state.holdHoveredSection);
	const setHoldHoveredSection = useStore(state => state.setHoldHoveredSection);
	const setMouse = useStore(state => state.setMouse);
	const sortSection = useStore(state => state.sortSection)
	
	const [shelfedData, setShelfedData] = useState(false);
	
	const [pos, setPos] = useState(false)
	const [clicked, setClicked] = useState(false)
	
	const selectedBook = useStore(state => state.selectedBook);
	const setSelectedBook = useStore(state => state.setSelectedBook);
	
	const storedSubCats = useStore(state => state.storedSubCats);
	
	const currentShelf = useStore(state => state.currentShelf);
	
	const nightMode = useStore(state => state.nightMode);
	const setNightmode = useStore(state => state.setNightMode);
	const [background, setBackground] = useState();
	useEffect(() => {
		setBackground(nightMode ? '#666' : 'var(--background)')
	}, [nightMode]);
	
	const halfWidth = width / 2;
	const halfHeight = height / 2;
	
	const radiusHeight = side * 0.1;
	const radiusTop = side * 0.08;
	
	const colors = useStore.getState().colors;
	
	const xscale = scaleLinear([0, 100], [halfWidth - radiusTop, halfWidth + radiusTop]);
	const yscale = scaleLinear([0, 100], [halfHeight - radiusHeight, halfHeight + radiusHeight]);
	
	const scale = (x, y, skewFactor = 0.01) => {
		const skewed = scaleLinear([0, 100], [skewFactor * (y / 100), -skewFactor * (y / 100)]);
		return [xscale(x + (100 * skewed(x))), yscale(y)];
	}
	
	useEffect(() => {
		setSelectedBook(clicked)
	}, [clicked, setSelectedBook]);
	
	useEffect(() => {
		if (hoveredSection) {
			setHoldHoveredSection(hoveredSection)
			setPos(getIndex(hoveredSection))
			if (SVGref.current) {
			}
		}
	}, [hoveredSection, setHoldHoveredSection]);
	
	useEffect(() => {
	}, [holdHoveredSection]);
	
	useEffect(() => {
	}, [selectedBook]);
	
	useEffect(() => {
		
		if (!storedSubCats) return
		
		if (!currentShelf) {
			setShelfedData(false)
			return
		}
		
		var newData = [];
		ZZsections.map((section) => {
			const sec = storedSubCats.all[currentShelf].filter((book) => book.Shelf === currentShelf && book.Section === section)
			newData[section] = sec
		})
		
		setShelfedData(newData)
		
	}, [storedSubCats, currentShelf, sortSection, ZZsections]);
	
	
	const onMouseMove = (e) => {
		let rect = e.currentTarget.getBoundingClientRect();
		let x = e.clientX - rect.left;
		let y = e.clientY - rect.top;
		
		let sectionName = ZZsections.find((f, i) => "section" + i === holdHoveredSection)
		
		let currentSection = shelfedData[sectionName]
		let mouseRange = rectRef.current.getBoundingClientRect().width
		
		const rescaleMouse = scaleLinear().domain([0, mouseRange]).range([0, 100]);
		const bookScale = scaleLinear().domain([0, 100]).range([1, currentSection.length]);
		
		let bookIndex = Math.round(bookScale(rescaleMouse(x))) - 1
		if (bookIndex >= currentSection.length) bookIndex = currentSection.length
		
		setHoveredBook(currentSection[bookIndex] ? currentSection[bookIndex] : false)
		
		if (x) {
			setMouse([rescaleMouse(x), y]);
		}
	};
	
	const inTimerange = (book) => {
		
		var isMember = true;
		if (selectedLegend && mode === 'memberships') {
			isMember = hoveredMember.value === book.membership ? true : false;
		}
		if (selectedLegend && mode === 'colors') {
			isMember = (book.Farbklassifizierung !== "" && hoveredColor.subid === book.Farbklassifizierung) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "uncertain" && book.membership === 2) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "noneugeniana" && book.membership === 0)
				? true : false;
		}
		return isMember && filterTimerange && filterTimerange.x0 <= book['Anfang Veröffentlichungsdatum'] && filterTimerange.x1 >= book['Anfang Veröffentlichungsdatum'] ? true : false;
	}
	
	const checkSelected = (book) => {
		
		var isMember = true;
		if (selectedLegend && mode === 'memberships') {
			isMember = hoveredMember.value === book.membership ? true : false;
		}
		if (selectedLegend && mode === 'colors') {
			isMember = (book.Farbklassifizierung !== "" && hoveredColor.subid === book.Farbklassifizierung) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "uncertain" && book.membership === 2) ||
			(book.Farbklassifizierung === "" && hoveredColor.id === "noneugeniana" && book.membership === 0)
				? true : false;
		}
		if (chartType === "time") {
			return inTimerange(book)
		} else if (chartType === "geo" || chartType === "geomap") {
			if (hoveredPlace && !filterPlace) {
				return book['Orte_corr'].includes(hoveredPlace) && isMember ? true : false
			} else if (filterPlace) {
				return book['Orte_corr'].includes(filterPlace) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "language") {
			if (hoveredLanguage) {
				return book['Sprache'].includes(hoveredLanguage) && isMember ? true : false
			} else if (filterLanguage) {
				return book['Sprache'].includes(filterLanguage) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "member") {
			return !hoveredMember || book['membership'] === hoveredMember.value ? true : false
		} else if (chartType === "taxonomy" || chartType === "taxonomyCircle") {
			if (hoveredTaxonomy.name === "root") return isMember ? true : false;
			if (hoveredTaxonomy) {
				return (book['Wissensklasse'] === hoveredTaxonomy.name || book['Wissensunterklasse'] === hoveredTaxonomy.name) && isMember ? true : false
			} else if (filterTaxonomy) {
				return (book['Wissensklasse'] === filterTaxonomy.name || book['Wissensunterklasse'] === filterTaxonomy.name) && isMember ? true : false
			}
			return isMember ? true : false;
		} else if (chartType === "color") {
			let visible = false
			if (hoveredColor && book['Farbklassifizierung'] === hoveredColor.subid) visible = true;
			else if (hoveredColor && hoveredColor.id === "uncertain" && book['Farbklassifizierung'] === "" && book['membership'] === 2) visible = true;
			else if (hoveredColor && hoveredColor.id === "noneugeniana" && book['Farbklassifizierung'] === "" && book['membership'] === 0) visible = true;
			return !hoveredColor || visible
		}
	}
	
	
	const getIndex = (sectionName) => {
		if (!sectionName) return
		let index = 0
		let parts = sectionName.split('section')
		if (parts && parts[1]) index = +parts[1];
		let stage = index / 2 - (index % 2) / 2
		return stage * (side * 0.035)
	}
	
	const getColor = (book) => {
		if (mode === "memberships") {
			return book.membership ? colors.membership[book.membership] : book.membership == 2 ? 'white' : colors.membership[0]
		}
		if (mode === "colors") {
			return book.Farbklassifizierung ? colors.Farbklassifizierung[book.Farbklassifizierung] : book.membership == 2 ? 'white' : colors.membership[0]
		}
		return 'blue'
	}
	
	if (!shelfedData) return <></>
	return (
		<svg width={'100%'} height={'100%'} x={side * 0.065} y={side * 0.393 - pos} preserveAspectRatio="xMinYMin slice"
		     ref={SVGref}>
			<g
				className={styles.bookshelfBox}
				onClick={() => !holdHoveredSection ? setClicked(false) : null}
				onMouseLeave={() => {
					setHoveredSection(false);
					setHoldHoveredSection(false)
				}}
				transform={"scale(6, 2.4) translate(0, 0)"}
				style={{visibility: holdHoveredSection ? 'visible' : 'hidden'}}
			>
				<rect
					x={scale(-2, 0)[0]}
					y={scale(-2, 0)[1]}
					width={side * 0.15}
					height={side * 0.04}
					fill={background}
					stroke={'var(--ovalBorders)'}
					strokeWidth={0.5}
				>
				</rect>
				
				{ZZsections.map((row, index) => {
					if (holdHoveredSection !== 'section' + index) return
					const sectionLength = shelfedData[row].length
					const bookSize = sectionLength > 0 ? 1 / sectionLength * 90 : 100
					
					return (
						<g
							id={"section" + index}
							key={`xsection-${index}`}
							className={styles.bookshelfBox}
							transform={'scale(1, 0.95) translate(0,2)'}
							onMouseMove={onMouseMove}
							onClick={() => {
								setClicked(clicked === hoveredBook ? false : hoveredBook);
							}}
						>
							{shelfedData[row].map((book, bookIndex) => {
									let perc = bookIndex / sectionLength * 100 * 0.9;
									return (
										<g
											id={'x' + index + '_' + bookIndex}
											key={`stacked-book-${index}-${bookIndex}`}
										>
											<rect
												key={`xstacked-bar-${index}-${bookIndex}`}
												style={{pointerEvents: 'none'}}
												x={scale(perc, (1) * 1, 0.0)[0]}
												y={scale(perc, (1) * 1, 0.0)[1]}
												width={bookSize * 0.35}
												height={side * 0.021}
												fill={(hoveredBook === book) ? 'purple' : clicked === book ? 'black' : getColor(book)}
												fillOpacity={checkSelected(book) || (hoveredBook === book) ? 1 : 0.2}
											></rect>
											{hoveredBook === book && holdHoveredSection === "section" + index &&
												<ellipse
													id={'indicatorZoomed'}
													cx={scale(perc + bookSize * 0.20, 1, 0.0)[0]}
													cy={scale(perc + bookSize * 0.20, 1, 0.0)[1]}
													rx={side * 0.001}
													ry={side * 0.0025}
													fill={'purple'}
												>
												</ellipse>
											}
										</g>
									)
								}
							)}
							{
								<rect
									className={'zoomedSection'} ref={rectRef}
									x={scale(0, 1 * 1, 0)[0]}
									y={scale(0, 1 * 1, 0)[1]}
									width={side * 0.072 * 2}
									height={side * 0.022}
									fill={'blue'}
									opacity={0.0}
								></rect>
							}
							<use href="#indicatorZoomed"/>
							<use href=".zoomedSection"/>
						</g>
					)
				})}
			</g>
		</svg>
	)
})
