/* eslint-disable react/prop-types */

import styles from "../styles.module.css";
import {useState} from 'react';
import {useStore} from "../store";
import {arrayRange} from "../lib/array-range"

export const OverviewBookshelf = (props) => {

    const {width, height, side, shelf} = props;
    const [hover, setHover] = useState(false);

    const stats = useStore(state => state.stats);
    const currentShelf = useStore(state => state.currentShelf);
    const setCurrentShelf = useStore(state => state.setCurrentShelf);
    const setHoverShelf = useStore(state => state.setHoverShelf)

    const halfWidth = width / 2;
    const halfHeight = height / 2;

    const radiusHeight = side * 0.1;
    const radiusTop = side * 0.08;
    const radiusBottom = side * 0.06;

	const totalBookCount = stats.subcategories.all[shelf.id+'.'];
    const eugeniana = stats.subcategories.eugeniana[shelf.id+'.']
    const nonEugeniana = stats.subcategories.noneugeniana[shelf.id+'.']
    const uncertain = stats.subcategories.uncertain[shelf.id+'.']

    const eugenianaShare = eugeniana / totalBookCount * 100;
    const uncertainShare = uncertain / totalBookCount * 100;
    const nonEugenianaShare = nonEugeniana / totalBookCount * 100;

    const shares = [eugenianaShare, eugenianaShare+uncertainShare, eugenianaShare+uncertainShare+nonEugenianaShare];

    const colors = ["#ff7c80", "#FBBE97", "lightgray"]
    let currentShare = 0

    return (
        <g
            className={styles.bookshelfGroup}
            transform={shelf.transform}
            onMouseEnter={() => {
                setHover(true);
                setHoverShelf(`${shelf.id}.`);
            }}
            onMouseLeave={() => {
                setHover(false);
                setHoverShelf(null);
            }}
            onClick={()=>setCurrentShelf( currentShelf !== `${shelf.id}.` ? `${shelf.id}.` : false)}>
            <polygon
                points={`${halfWidth - radiusTop},${halfHeight - radiusHeight}, ${halfWidth + radiusTop},${halfHeight - radiusHeight}, ${halfWidth + radiusBottom},${halfHeight + radiusHeight}, ${halfWidth - radiusBottom},${halfHeight + radiusHeight}`}
                strokeWidth={side*0.004}
                fill={hover ? '#fff' : 'rgb(255, 241, 230)'}
                className={styles.overviewBookshelf}
                stroke={`${shelf.id}.` === currentShelf ? '#dbc8ba' : 'rgb(246, 224, 209)'}
            />
            <text
                x={halfWidth}
                y={halfHeight -  side * 0.1}
                className={styles.ovalTitle}
                textAnchor='middle'
                filter="url(#whiteOutlineEffect)"
                fontSize={side * 0.018}
            >
                <tspan alignmentBaseline='before-edge'>
                    {shelf.label}
                </tspan>
            </text>
            <g>
                {arrayRange(1,20,1).map((row, index) => {
                    const binSize = 5;
                    if ((binSize * row) > (Math.round(shares[currentShare] / 5) * 5) ){
                        currentShare++;
                    }

                    return (
                        <rect
                            key={`stacked-bar-${shelf.id}-${index}`}
                            x={halfWidth - (radiusBottom * 0.9) - ((1+index) * side * 0.0008)}
                            y={(halfHeight + radiusHeight) - ((1+index) * side * 0.0087)}
                            width={2 * ((1+index) * side * 0.0008) + 1.8 * radiusBottom}
                            height={side * 0.0055}
                            fill={colors[currentShare]}
                        />
                    )
                })}
            </g>
        </g>
    )
}


