import styles from "../styles.module.css";
import React, {useEffect, useState} from "react";
import {useStore} from "../store.js";

import {MdAccessTime, MdStarRate} from "react-icons/md";
import {RiBubbleChartLine} from "react-icons/ri";
import {IoMdGlobe} from "react-icons/io";
import {VscComment} from "react-icons/vsc";
import {CustomIconCirclePacking} from "./CustomIcons.jsx"

export const NavBar = () => {
	
	const mode = useStore(state => state.mode)
	const setMode = useStore(state => state.setMode)
	
	const remInPx = useStore(state => state.remInPx);
	
	const setShowTutorial = useStore(state => state.setShowTutorial)
	
	const setShowImpressum = useStore(state => state.setShowImpressum)
	
	const chartType = useStore(state => state.chartType);
	const setChartType = useStore(state => state.setChartType);
	
	const setHoveredBook = useStore(state => state.setHoveredBook);
	
	const setFilterTimerange = useStore(state => state.setFilterTimerange)
	
	const filterMembership = useStore(state => state.filterMembership)
	const setFilterMembership = useStore(state => state.setFilterMembership)
	
	const setFilterTaxonomy = useStore(state => state.setFilterTaxonomy)
	
	const setFilterPlace = useStore(state => state.setFilterPlace)
	
	const setShowShelfHint = useStore(state => state.setShowShelfHint);
	
	const showTour = useStore(state => state.showTour)
	const setShowTour = useStore(state => state.setShowTour)
	
	const showStories = useStore(state => state.showStories)
	const setShowStories = useStore(state => state.setShowStories)
	
	const showHighlights = useStore(state => state.showHighlights)
	const setShowHighlights = useStore(state => state.setShowHighlights)
	
	const setSelectedLegend = useStore(state => state.setSelectedLegend);
	
	const [hoveredButton, setHoveredButton] = useState(null);
	
	const handleClick = (e) => {
		let target = e.currentTarget.id;
		
		if (target === 'highlight') {
			setShowHighlights(!showHighlights);
			return;
		}
		
		if (target === 'memberships' || target === 'colors') {

			if (chartType === 'color' && target === 'memberships' && mode === "colors") { setChartType('member'); }
			if (chartType === 'member' && target === 'colors' && mode === "memberships") { setChartType('color'); }
			// Change Farbschema without affecting highlight mode
			setMode(target);
			setSelectedLegend(false);
			
		}
		if (target === 'member' || target === 'color') {
			setChartType(target);
			if (showHighlights) {
				setShowHighlights(false);
			}
		} else if (['taxonomyCircle', 'time', 'geomap', 'language'].includes(target)) {
			setChartType(target);
			setShowHighlights(false); // Turn off highlights for these chart types
		} else if (['impressum', 'tutorial', 'tour3d', 'stories'].includes(target)) {
			if (target === 'impressum') setShowImpressum(true);
			if (target === 'tutorial') setShowTutorial(true);
			if (target === 'tour3d') setShowTour(true);
			if (target === 'stories') setShowStories(true);
			return;
		}
		
		if (filterMembership) {
			setFilterMembership(null);
		}
	};
	
	useEffect(() => {
		
		setFilterMembership(null)
		setFilterTimerange(null)
		setFilterPlace(null)
		setFilterTaxonomy(null)
		
	}, [chartType]);
	
	
	useEffect(() => {}, [filterMembership, showHighlights])
	
	const getButtonStyle = (buttonId) => {
		
		const isActive =
			(buttonId === 'highlight' && showHighlights) ||
			(buttonId === chartType && !showHighlights); // Only active if highlights are off
		
		return {
			fontWeight: isActive ? 'bold' : 'normal',
			color: isActive ? 'black' : 'grey',
			borderColor: isActive || hoveredButton === buttonId ? 'black' : 'grey',
			borderWidth: isActive || hoveredButton === buttonId ? 2 : 1,
			background: isActive ? '#ffffff99' : '#ffffff66',
		};
	};
	
	const viewDescription = {
		'highlight': 'Home & Highlights',
		'taxonomyCircle' : 'Wissensklassen',
		'time' : 'Zeitverlauf',
		'geomap' : 'Landkarte',
		'language' : 'Sprachen',
		'member' : 'Zugehörigkeit',
		'color' : 'Einbandfarbe',
	}
	
	return (
		<>
			<div className={styles.NavBar}
			     onMouseEnter={() => setHoveredBook(false)}
			>
				<div className={styles.NavBarItem}
				     style={{flex: 1, display: 'flex', flexWrap: 'nowrap', alignItems: 'baseline'}}>
					<div style={{alignSelf: 'flex-start', marginTop: '0.2rem', padding: '0.1rem 0.2rem 0 0.2rem'}}>
						<img src={'amorial_03.png'} width={`${remInPx*2.3}`}/>
					</div>
					<div className={styles.NavBarTitle}
					     onClick={() => setShowShelfHint(true)}
					>
						Bibliotheca Eugeniana Digital
					</div>
					<div className={styles.NavBarViews}>|  {viewDescription[showHighlights ? 'highlight' : chartType]}</div>
				</div>
				<div className={styles.NavItemsConatiner} style={{flex: 2}}>
					
					<div className={styles.NavBarItem} style={{flex: 1}}></div>
					<div className={styles.NavBarItem} style={{}}>Farbschema:</div>
					
					<div className={styles.NavBarButton} id={'memberships'} onClick={handleClick}
					     style={{textDecoration: mode === "memberships" ? "underline" : "unset"}}
					     title={'Farbschema: Zugehörigkeit zur Eugeniana'}
					>
						Zugehörigkeit
					</div>
					<div className={styles.NavBarItem}>
						|
					</div>
					<div className={styles.NavBarButton} id={'colors'} onClick={handleClick}
					     style={{textDecoration: mode === "colors" ? "underline" : "unset"}}
					     title={'Farbschema: Klassifikation der Farbe der Einbände'}
					>
						Einbandfarbe
					</div>
					
					<div className={styles.NavBarItem} style={{flex: 2}}></div>
					
					{(mode === "memberships" || mode === "colors") &&
						<div className={styles.NavBarIconGroup} style={{flex: 5, alignItems: 'baseline'}}>
							
							<div id="highlight" className={styles.NavBarIconButton}
							     onClick={handleClick}
							     onMouseEnter={() => setHoveredButton("highlight")}
							     onMouseLeave={() => setHoveredButton(null)}
							     style={getButtonStyle("highlight")}
							     title={"Highlights des Prunksaals"}
							>
								<MdStarRate className={styles.NavBarIcon} size={'1.3rem'}/>
							</div>
							
							<div id="taxonomyCircle" className={styles.NavBarIconButton} onClick={handleClick}
							     onMouseEnter={() => setHoveredButton("taxonomyCircle")}
							     onMouseLeave={() => setHoveredButton(null)}
							     style={getButtonStyle("taxonomyCircle")}
							     title={"Wissensklassifikation der Eugenianabibliothek"}
							>
								<CustomIconCirclePacking className={styles.NavBarIcon} width={remInPx*1.3} height={remInPx*1.35}/>
							</div>
							
							<div id="time" className={styles.NavBarIconButton} onClick={handleClick}
							     onMouseEnter={() => setHoveredButton("time")}
							     onMouseLeave={() => setHoveredButton(null)}
							     style={getButtonStyle("time")}
							     title={"Zeitdiagramm nach Veröffentlichungsdatum"}
							>
								{/*{chartType === 'time' ? 'Zeit' : 'Zeit'}*/}
								<MdAccessTime className={styles.NavBarIcon} size={'1.3rem'}/>
							</div>
							
							<div id="geomap" className={styles.NavBarIconButton} onClick={handleClick}
							     onMouseEnter={() => setHoveredButton("geomap")}
							     onMouseLeave={() => setHoveredButton(null)}
							     style={getButtonStyle("geomap")}
							     title={"Landkarte zur Eugenianabibliothek"}
							>
								{/*{chartType === 'member' ? 'Zugehörigkeit' : 'Zugehörigkeit'}*/}
								<IoMdGlobe className={styles.NavBarIcon} size={'1.3rem'}/>
							</div>
							
							<div id="language" className={styles.NavBarIconButton} onClick={handleClick}
							     onMouseEnter={() => setHoveredButton("language")}
							     onMouseLeave={() => setHoveredButton(null)}
							     style={getButtonStyle("language")}
							     title={"Sprachen (Häufigkeiten)"}
							>
								<VscComment className={styles.NavBarIcon} size={'1.3rem'}/>
							</div>
							
							{mode === 'colors' &&
								<div id="color" className={styles.NavBarIconButton} onClick={handleClick}
								     onMouseEnter={() => setHoveredButton("color")}
								     onMouseLeave={() => setHoveredButton(null)}
								     style={getButtonStyle("color")}
								     title={"Kategorisierung der Wappen und Einbände"}
								>
									<RiBubbleChartLine className={styles.NavBarIcon} size={'1.3rem'}/>
								</div>
							}
							{mode === "memberships" &&
								<div id="member" className={styles.NavBarIconButton} onClick={handleClick}
								     onMouseEnter={() => setHoveredButton("member")}
								     onMouseLeave={() => setHoveredButton(null)}
								     style={getButtonStyle("member")}
								     title={"Zugehörigkeit zur Eugenianabibliothek"}
								>
									<RiBubbleChartLine className={styles.NavBarIcon} size={'1.3rem'}/>
								</div>
							}
							
							<div className={styles.NavBarItem} style={{flex: 2}}></div>
							
							<div id="stories" className={styles.NavBarLink} onClick={handleClick}
							     style={{flex: 1, marginLeft: '2%'}}
							>
								Story
							</div>
							
							<div id="tutorial" className={styles.NavBarLink} onClick={handleClick}
								 style={{flex: 1, margin: '0%'}}
							>
								Tutorial
							</div>
							
							
							<div id="impressum" className={styles.NavBarLink} onClick={handleClick}
							     style={{flex: 1, marginRight: '3%'}}
							>
								Impressum
							</div>
							
							<div className={styles.NavBarItem}
							     style={{flex: 1, justifySelf: 'flex-start', paddingRight: '2em'}}>
								<img src={'ONB_Logo_rgb.png'} height={`${remInPx*1.4}px`}/>
							</div>
							
							<div className={styles.NavBarItem} style={{flex: 2}}></div>
							
						</div>
					}
				</div>
			
			</div>
		</>
	)
}
