///* eslint-disable react/prop-types */
import {useState, useEffect} from 'react';
import {useMeasure} from "react-use";
import styles from "../styles.module.css";
import {useStore} from '../store';
import {createMembershipCategories} from '../lib/categories.jsx';

export const MembershipView = () => {
	
	const [ref, {width, height}] = useMeasure();
	
	const [side, setSide] = useState(Math.min(width, height));
	
	const filterMembership = useStore(state => state.filterMembership);
	const setFilterMembership = useStore(state => state.setFilterMembership);
	
	const setSelectedBook = useStore(state => state.setSelectedBook);
	
	const hoveredMember = useStore(state => state.hoveredMember);
	const setHoveredMember = useStore(state => state.setHoveredMember);
	
	const isFirefox = useStore(state => state.isFirefox);
	
	const hoverShelf = useStore(state => state.hoverShelf);
	const storedSubCats = useStore(state => state.storedSubCats);
	
	const stats = useStore(state => state.stats);
	
	const colors = useStore(state => state.colors);
	const [categories, setCategories] = useState(null);
	
	useEffect(() => {
		if (!storedSubCats) return;
		const cats = createMembershipCategories(stats, colors, hoverShelf);
		setCategories(cats);
	}, [stats, hoverShelf, storedSubCats, colors]);
	
	useEffect(() => {
		setSide(Math.min(width, height));
	}, [width, height]);
	
	useEffect(() => {
		if (!filterMembership) {
			setFilterMembership(null);
			setHoveredMember(false);
		}
	}, [filterMembership, setFilterMembership, setHoveredMember]);
	
	if (categories == null) {
		return <p>Loading ...</p>;
	}
	
	return (
		<svg className={styles.svgDiv} width={'100%'} height={'100%'} ref={ref}>
			<g onClick={() => setFilterMembership(null)}>
				<rect
					x={0}
					y={0}
					width={'100%'}
					height={'100%'}
					fill={'#FFFFFF00'}
				/>
			</g>
			{categories.map((category, index) => (
				<g key={`category-${index}`}
				   style={{cursor: 'pointer'}}
				   transform={`translate(${side / 45 * Math.pow((category.data / 100), 0.5) * category.tX} ${side / 45 * Math.pow((category.data / 100), 0.5) * category.tY})`}
				   onClick={() => {
					   setSelectedBook(false);
					   setFilterMembership(filterMembership && category.id === filterMembership.id ? null : category);
					   setHoveredMember(category);
				   }}
				   onMouseEnter={() => filterMembership ? null : setHoveredMember(category)}
				   onMouseLeave={() => filterMembership ? null : setHoveredMember(false)}>
					<circle
						r={side / 50 * Math.pow((category.data / 100), 0.5)}
						cx={width / 2} cy={height / 2}
						fill={hoverShelf == null ? category.fill : 'none'}
						stroke={hoverShelf != null ? category.fill : 'none'}
						strokeWidth={2}
						opacity={(filterMembership && filterMembership.id !== category.id)
						|| (hoveredMember && hoveredMember?.id !== category.id)
							? 0.3 : 1}
					/>
					{hoverShelf != null && (
						<circle
							r={side / 50 * Math.pow((category.dataSub / 100), 0.5)}
							cx={width / 2} cy={height / 2}
							fill={category.fill}
							opacity={filterMembership && filterMembership.id !== category.id ? 0.3 : 1}
						/>
					)}
					<text
						x={width / 2}
						y={height / 2}
						textAnchor='middle'
						fontSize={filterMembership && filterMembership.id === category.id ? side * 0.03 : side * 0.023}
						fontWeight={filterMembership && filterMembership.id === category.id ? 600 : 500}>
						<tspan alignmentBaseline='ideographic'>{category.label}</tspan>
					</text>
					<text
						x={width / 2}
						y={height / 2}
						textAnchor='middle'
						fontWeight={'bold'}
						fontSize={side * 0.018}>
						<tspan dy={isFirefox ? side * 0.03 : 0} alignmentBaseline='hanging'>
							{hoverShelf == null ? category.data : `${category.dataSub} / ${category.data}`}
						</tspan>
					</text>
				</g>
			))}
			{hoverShelf != null && (
				<text
					x={width / 2 + side * 0.025}
					y={height / 2 - side * 0.05}
					textAnchor='middle'
					fontSize={side * 0.02}
					fontWeight={'600'}>
					{hoverShelf.slice(0, -1)}
				</text>
			)}
		</svg>
	);
}
