import {useStore} from "../store.js";
import styles from "../styles.module.css";
import PropTypes from 'prop-types';
import {useEffect, useState} from "react";
import {createColorCategories, createMembershipCategories} from "../lib/categories.jsx";

export const Legend = (props) => {
	
	const dim = useStore(state => state.dim);
	const legend = useStore(state => state.legend)
	const selectedLegend = useStore(state => state.selectedLegend);
	
	const {dataset, style} = props;
	
	useEffect(() => {
	}, [selectedLegend])
	
	let array = typeof dataset !== 'string' ? dataset : legend[dataset];
	
	return (
		<div className={styles.legendContainer} style={{...style}}>
			<div className={styles.legendBox}
			     style={{
				     width: dim.middle.width * 1.2,
				     top: dim.top.height * 1.2,
				     left: dim.left.width * 0.98,
				     display: 'flex',
				     flexDirection: 'row',
				     flexWrap: 'wrap',
				     alignItems: 'center'
			     }}>
				{dataset && array.map((d, i) =>
					<Box
						id={i + 1}
						selected={selectedLegend}
						key={'legendItem' + dataset + i}
						color={d.color}
						txt={d.text}
						title={d.title}
					/>
				)}
			</div>
		</div>
	)
}

export const Box = (props) => {
	
	const remInPx = useStore(state => state.remInPx);
	const selectedLegend = useStore(state => state.selectedLegend);
	const setSelectedLegend = useStore(state => state.setSelectedLegend);
	const filterMembership = useStore(state => state.filterMembership);
	const setFilterMembership = useStore(state => state.setFilterMembership)
	const setSelectedBook = useStore(state => state.setSelectedBook)
	const hoverShelf = useStore(state => state.hoverShelf);
	const storedSubCats = useStore(state => state.storedSubCats);
	const stats = useStore(state => state.stats);
	const colors = useStore(state => state.colors);
	const mode = useStore(state => state.mode);
	const setHoveredMember = useStore(state => state.setHoveredMember);
	const setHoveredColor = useStore(state => state.setHoveredColor);
	const hoveredMember = useStore(state => state.hoveredMember);
	
	const {color, txt, title, id} = props;
	const [colorCategories, setColorCategories] = useState(null);
	const [memberCategories, setMemberCategories] = useState(null);
	
	const boxsize = remInPx * 0.7;
	
	const handleClick = (e) => {
		
		setSelectedBook(false)
		
		setSelectedLegend(selectedLegend == id ? false : id)
		
		if (selectedLegend === id) {
			setFilterMembership(null)
			setHoveredColor(false)
			setHoveredMember(false)
		} else if (mode === 'memberships') {
			setFilterMembership(memberCategories.find((d) => d.idx === id))
			setHoveredMember(memberCategories.find((d) => d.idx === id))
		} else if (mode === 'colors') {
			setHoveredColor(colorCategories.find((d) => d.idx === id))
			setFilterMembership(colorCategories.find((d) => d.idx === id))
		}
		
	}
	
	useEffect(() => {
		if (!storedSubCats) return;
		const cats = createColorCategories(stats, colors, hoverShelf);
		setColorCategories(cats);
	}, [stats, hoverShelf, storedSubCats, colors]);
	
	useEffect(() => {
		if (!storedSubCats) return;
		const cats = createMembershipCategories(stats, colors, hoverShelf);
		setMemberCategories(cats);
	}, [stats, hoverShelf, storedSubCats, colors]);
	
	useEffect(()=>{
		setSelectedLegend(filterMembership?.idx ?? false)
	}, [filterMembership])
	
	return (
		<div style={{
			display: 'flex',
			flexDirection: 'row',
			alignItems: 'center',
			pointerEvents: 'auto'
		}} title={title}>
			{id === 1 && <div style={{fontSize: '1rem', marginRight: '0.5rem'}}>Filter:</div>}
			<div
				onClick={handleClick}
				style={{
					cursor: 'pointer',
					backgroundColor: selectedLegend ? selectedLegend === id ? color : 'transparent' : color,
					border: selectedLegend ? selectedLegend === id ? '1px solid transparent' : '1px solid #666' : '1px solid transparent',
					width: boxsize,
					height: boxsize,
					margin: '0.1rem',
					pointerEvents: 'auto'
				}}
			>&nbsp;</div>
			<div
				onClick={handleClick}
				style={{
					paddingLeft: '0.4em',
					paddingRight: '1.4em',
					whiteSpace: 'nowrap',
					pointerEvents: 'auto',
					cursor: 'pointer'
				}}
			>
				{txt}
			</div>
		</div>
	)
}
