import {useStore} from "../store.js";
import {useEffect, useState} from "react";
import styles from "../styles.module.css";
import {VscFilter} from "react-icons/vsc";

export const Languages = () => {
	
	const stats = useStore(state => state.stats);
	const dim = useStore(state => state.dim);
	const mode = useStore(state => state.mode);
	const selectedLegend = useStore(state => state.selectedLegend);
	
	const hoveredLanguage = useStore(state => state.hoveredLanguage);
	const setHoveredLanguage = useStore(state => state.setHoveredLanguage);
	
	const filterLanguage = useStore(state => state.filterLanguage);
	const setFilterLanguage = useStore(state => state.setFilterLanguage);
	
	const hoveredBook = useStore(state => state.hoveredBook);
	
	const translateLanguage = useStore(state => state.translateLanguage);
	
	const [outOfListLanguage, setOutOfListLanguage] = useState(null);
	const [selectedLanguage, setSelectedLanguage] = useState(null);
	const [remoteHovered, setRemoteHovered] = useState(null);
	const [maxSize, setMaxSize] = useState(0);
	const [more, setMore] = useState(false);
	const [data, setData] = useState([]);
	const [factor, setFactor] = useState(0);

	
	useEffect(() => {
		const book = hoveredBook;
		if (!book) {
			setRemoteHovered(null);
			setOutOfListLanguage(null);
			return;
		}
		if (book && book.Sprache) {
			setRemoteHovered(book.Sprache);
			// Check if the language is in the current list
			const languageInList = data.some(d => d.name === book.Sprache);
			if (!languageInList) {
				// If not in the list, find the language count from the full list
				const languageInfo = stats.languages.languagesList.find(l => l.name === book.Sprache);
				setOutOfListLanguage(languageInfo);
			} else {
				setOutOfListLanguage(null);
			}
		} else {
			setRemoteHovered(null);
			setOutOfListLanguage(null);
		}
	}, [hoveredBook, data, stats.languages.languagesList]);
	
	useEffect(() => {
		if (!stats || !stats.languages) return;
		
		let selectedData;
		
		if (!selectedLegend) {
			// Use default data when no legend is selected
			selectedData = more ? stats.languages.languagesList : stats.languages.topTen;
		} else {
			// Select data based on mode and selectedLegend
			if (mode === 'memberships') {
				switch(selectedLegend) {
					case 1:
						selectedData = more ? stats.languages.categories.eugeniana.allLanguages : stats.languages.categories.eugeniana.topTen;
						break;
					case 2:
						selectedData = more ? stats.languages.categories.uncertain.allLanguages : stats.languages.categories.uncertain.topTen;
						break;
					case 3:
						selectedData = more ? stats.languages.categories.noneugeniana.allLanguages : stats.languages.categories.noneugeniana.topTen;
						break;
					default:
						selectedData = more ? stats.languages.languagesList : stats.languages.topTen;
				}
			} else if (mode === 'colors') {
				switch(selectedLegend) {
					case 1:
						selectedData = more ? stats.languages.categories.eugeniana_yellow.allLanguages : stats.languages.categories.eugeniana_yellow.topTen;
						break;
					case 2:
						selectedData = more ? stats.languages.categories.eugeniana_red.allLanguages : stats.languages.categories.eugeniana_red.topTen;
						break;
					case 3:
						selectedData = more ? stats.languages.categories.eugeniana_blue.allLanguages : stats.languages.categories.eugeniana_blue.topTen;
						break;
					case 4:
						selectedData = more ? stats.languages.categories.uncertain.allLanguages : stats.languages.categories.uncertain.topTen;
						break;
					case 5:
						selectedData = more ? stats.languages.categories.noneugeniana.allLanguages : stats.languages.categories.noneugeniana.topTen;
						break;
					default:
						selectedData = more ? stats.languages.languagesList : stats.languages.topTen;
				}
			}
		}
		
		// Calculate max size for visualization scaling
		const max = selectedData.reduce((prev, current) =>
			(prev && prev.cnt > current.cnt) ? prev : current
		);
		
		let radius = 0.005;
		let newFactor = dim.right.height / 1300 * radius;
		setFactor(newFactor);
		
		setMaxSize(max.cnt * newFactor);
		setData(selectedData);
	}, [stats, more, dim, mode, selectedLegend]);
	
	useEffect(() => {
		if (!hoveredLanguage && !selectedLanguage) {
			setFilterLanguage(false)
		} else if (selectedLanguage && hoveredLanguage && hoveredLanguage !== selectedLanguage) {
			return;
		} else if (selectedLanguage) {
			setFilterLanguage(selectedLanguage)
		}
	}, [hoveredLanguage, selectedLanguage, setFilterLanguage]);
	
	useEffect(() => {
		if (!filterLanguage) {
			setSelectedLanguage(null)
		}
	}, [filterLanguage]);
	
	
	useEffect(() => {
		setFilterLanguage(selectedLanguage)
	}, [selectedLanguage, setFilterLanguage]);
	
	
	useEffect(() => {
		const book = hoveredBook;
		if (!book) {
			setRemoteHovered(null);
			return
		}
		if (book && book.Sprache) {
			setRemoteHovered(book.Sprache)
		} else {
			setRemoteHovered(null)
		}
	}, [hoveredBook]);
	
	const handleMouseEnter = (language) => {
		if (!selectedLanguage) {
			setHoveredLanguage(language);
		}
	};
	
	const handleMouseLeave = () => {
		if (!selectedLanguage) {
			setHoveredLanguage(null);
		}
	};
	
	const handleClick = (language) => {
		if (selectedLanguage === language) {
			setSelectedLanguage(null);
			setHoveredLanguage(null);
		} else {
			setSelectedLanguage(language);
			setHoveredLanguage(language);
		}
	};
	
	const getBorderStyle = (currentLanguage) => {
		if (selectedLanguage === currentLanguage) return '2px solid darkgrey';
		if (remoteHovered === currentLanguage && !selectedLanguage) return '2px solid purple';
		return '2px solid transparent';
	};
	
	const getBackgroundColor = (currentLanguage) => {
		if ((hoveredLanguage === currentLanguage && !selectedLanguage) || selectedLanguage === currentLanguage) {
			return '#dddddd66';
		}
		return 'transparent';
	};
	
	if (!data.length) return null;
	
	return (
		<>
			<div className={styles.overlayContainerScroll} style={{marginTop: '4rem',padding: '5% 5% 5% -5%'}}>
				<div
					className={styles.Button}
					onClick={() => setMore(!more)}
					style={{position: 'absolute', bottom: '2.5em', right: '3rem'}}
				>
					{more ? 'Top 10' : 'mehr'}
				</div>
				
				<div>
					{data.map((d, i) => (
						<div
							key={`languages${i}`}
							style={{
								display: 'flex',
								flexDirection: 'row',
								justifyContent: 'space-between',
								alignItems: 'center',
								border: getBorderStyle(d.name),
								borderRadius: '0.6rem',
								padding: '5px',
								cursor: "pointer",
								background: getBackgroundColor(d.name),
								fontWeight: (hoveredLanguage === d.name && !selectedLanguage) || selectedLanguage === d.name ? 600 : 400,
							}}
							onMouseEnter={() => handleMouseEnter(d.name)}
							onMouseLeave={handleMouseLeave}
							onClick={() => handleClick(d.name)}
						>
							<div style={{width: '2rem', paddingLeft: '0.2rem', display: 'flex', height: '100%', alignItems: 'center'}}>
								{selectedLanguage === d.name && (
									<VscFilter className={styles.reactIcons} size={'1.2rem'}/>
								)}
							</div>
							<div style={{width: '10vw', paddingLeft: '0em', flex: 1, alignSelf: 'center'}}>
								{translateLanguage(d.name)}
							</div>
							<div style={{paddingLeft: '0em', flex: 1, alignSelf: 'center'}}>
								{d.cnt}
							</div>
							<div style={{
								marginRight: '1em',
								padding: '3px 3px 3px 20px',
								width: maxSize * 2 + 4,
								height: maxSize * 2 + 2,
								alignSelf: 'center'
							}}>
								<svg className={styles.svgDiv} width={'100%'} height={'100%'}
								     style={{background: 'transparent'}}>
									<circle
										cx={maxSize + 2}
										cy={maxSize + 1}
										r={d.cnt * factor + 1}
										fill={'#A38564'}
										stroke={'#A3856400'}
										strokeWidth={2}
									/>
								</svg>
							</div>
						</div>
					))}
				</div>
				
				{outOfListLanguage && (
					<div
						style={{
							position: 'absolute',
							bottom: '2em',
							left: dim.left.width + dim.middle.width + dim.right.width / 4,
							padding: '0.5em',
						}}
					>
						<strong>{translateLanguage(outOfListLanguage.name)}:</strong> {outOfListLanguage.cnt} Bücher
					</div>
				)}
			</div>
		</>
	);
};


