/* eslint-disable react/prop-types */
import styles from "../styles.module.css";

import {useEffect, useRef} from 'react';
import {useStore} from "../store.js";
import {useMeasure} from "react-use";
import {PiNavigationArrowBold} from "react-icons/pi";
import {useSpring, a, config, easings} from "@react-spring/web";

export const Hint = (props) => {

	const [ref, hint] = useMeasure();

	const firstRender = useStore(state => state.firstRender);

	const showShelfHint = useStore(state => state.showShelfHint);
	const setShowShelfHint = useStore(state => state.setShowShelfHint);

	const showCloseup = useStore(state => state.showCloseup);

	const dim = useStore(state => state.dim)

	const {opacity} = useSpring({
		opacity: showShelfHint ? 1 : 0,
		delay: 1000,
		config: {duration: 1500},
	})

	useEffect(() => {
	}, [dim, hint, showShelfHint, showCloseup])

	useEffect(() => {
		if (firstRender) {
			setTimeout(()=>{
				setShowShelfHint(true)
				}, [1000])
		}
	}, [firstRender]);


	const handleClose = () => {
		setShowShelfHint(false)
	}

	const offset = dim.screen.width / 100 * +1.7
//	const offset = dim.screen.width / 100 * -0.18

	return (
		<a.div style={{
			display: !showCloseup && showShelfHint ? 'block' : 'none',
			opacity: opacity
		}}
		     onClick={handleClose}
		>
			<div className={styles.shelfHint} ref={ref}
			     style={{
				     opacity: opacity,
				     top: dim.top.height + dim.middle.height / 2,
				     left: dim.left.width + dim.middle.width / 2 - hint.width / 2 + offset, // last computation corrects also padding of Oval
			     }}
			>
				Bitte klicken Sie auf ein Bücherregal! {showShelfHint}
			</div>

			<div className={styles.shelfHintContainer}
			     style={{
				     top: dim.top.height + dim.middle.height / 2 - hint.height * 0.7,
				     left: dim.left.width + dim.middle.width / 2 - hint.width / 2 - hint.height * 0.7 + offset, // last computation corrects also padding of Oval
			     }}>
				<PiNavigationArrowBold/>
			</div>

			<div className={styles.shelfHintContainer}
			     style={{
				     top: dim.top.height + dim.middle.height / 2 - hint.height * 0.7,
				     left: dim.left.width + dim.middle.width / 2 + hint.width / 2 + hint.height * 0.4 + offset, // last computation corrects also padding of Oval
				     transform: 'scaleX(-1)'
			     }}>
				<PiNavigationArrowBold/>
			</div>

			<div className={styles.shelfHintContainer}
			     style={{
				     top: dim.top.height + dim.middle.height / 2 + hint.height * 0.7,
				     left: dim.left.width + dim.middle.width / 2 - hint.width / 2 - hint.height * 0.7 + offset, // last computation corrects also padding of Oval
				     transform: 'scaleY(-1)'
			     }}>
				<PiNavigationArrowBold/>
			</div>

			<div className={styles.shelfHintContainer}
			     style={{
				     top: dim.top.height + dim.middle.height / 2 + hint.height * 0.7,
				     left: dim.left.width + dim.middle.width / 2 + hint.width / 2 + hint.height * 0.4 + offset, // last computation corrects also padding of Oval
				     transform: 'scale(-1, -1)'
			     }}>
				<PiNavigationArrowBold/>
			</div>

		</a.div>
	)

}
