import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle
import pandas as pd
import numpy as np
from matplotlib import rc
rc('font',**{'family':'serif','serif':['Palatino'], 'size': 14})
rc('text', usetex=True)

bb_df = pd.read_csv('../data/groundtruth/bounding_boxes.csv')
bb_df['cent_x'] = bb_df.apply(lambda x: x['BB_x/w'] + x['BB_w/w']/2, axis=1)
bb_df['cent_y'] = bb_df.apply(lambda x: x['BB_y/h'] + x['BB_h/h']/2, axis=1)

cent_x = bb_df['cent_x']
cent_y = bb_df['cent_y']
average_x = np.average(cent_x)
average_y = np.average(cent_y)
top_left_x = bb_df['BB_x/w']
top_left_y = bb_df['BB_y/h']

fig, ax = plt.subplots()
width = bb_df['BB_w/w']
height = bb_df['BB_h/h']
percentile = 0.97
hull_width = np.quantile(width, percentile)
hull_height = np.quantile(height, percentile)
# add bounding boxes
for x, y, w, h in zip(top_left_x, top_left_y, width, height):
    ax.add_patch(Rectangle(
        xy=(x, y), width=w, height=h, linewidth=1, color='#FF6F58', fill=False
    ))
# add chosen uniform bounding box for the classifier
ax.add_patch(Rectangle(
    xy=(average_x - hull_width/2, average_y - hull_height/2), width=hull_width, height=hull_height, linewidth=2,
    color='red', fill=False
))

ax.scatter(cent_x, cent_y, marker="x", color='#2F32EF')
ax.set(xlim=(0, 1), ylim=(0, 1))
ax.set_aspect(1.5)
plt.gca().invert_yaxis()
plt.title('Supralibros bounding boxes')
# plt.xlabel('Normierte Breite')
plt.xlabel('Normalized width')
# plt.ylabel('Normierte Höhe')
plt.ylabel('Normalized height')

# plt.show()
plt.savefig('../img/documentation/bounding_boxes_eng.png', bbox_inches='tight', dpi=300)
print('Die Daten des 97% Quantil Rechtecks sind x,y,w,h =', average_x, average_y, hull_width, hull_height)
print('Ausgedrueckt in Koordinaten fuer iiif ist das', (average_x - hull_width/2)*100, (average_y - hull_height/2)*100,
      hull_width*100, hull_height*100)
