import pathlib
import pandas as pd
import numpy as np
import requests
from download_catalog import get_content
import cv2


def get_category(entry):
    match entry:
        case 'A':
            return 'A'
        case 'B':
            return 'B'
        case 'C':
            return 'C'
        case _:
            return 'N'


if __name__ == '__main__':
    img_dir = pathlib.Path('img')
    if not img_dir.exists():
        img_dir.mkdir()
    GT_path = img_dir.joinpath('GT_full')
    GT_cutout_path = img_dir.joinpath('GT_cutout')
    if not GT_path.exists():
        GT_path.mkdir()
    if not GT_cutout_path.exists():
        GT_cutout_path.mkdir()
    GT_csv = pd.read_csv('../Groundtruth/BE_GT.csv')
    for category, image_urls in zip(GT_csv['Variante'], GT_csv['Image URLs']):
        parsed_lis = eval(image_urls)
        cat = get_category(category)
        GT_cat_path = GT_path.joinpath(cat)
        GT_cutout_cat_path = GT_cutout_path.joinpath(cat)
        if not GT_cat_path.exists():
            GT_cat_path.mkdir()
        if not GT_cutout_cat_path.exists():
            GT_cutout_cat_path.mkdir()
        for url in parsed_lis:
            filename = url.replace('https://iiif.onb.ac.at/images/', '').replace('/full/full/0/native', '') \
                .replace('/', '')
            filepath = GT_cat_path.joinpath(filename)
            cutout_filepath = GT_cutout_cat_path.joinpath(filename)
            if not filepath.exists():
                img_content = get_content(url)
                open(filepath, 'wb').write(img_content)
            if not cutout_filepath.exists():
                cutout_url = url.replace('full', 'pct:22.5,28.5,53.7,43.7', 1)
                if 'REPO' not in cutout_url:
                    cutout_img_content = get_content(cutout_url)
                    open(cutout_filepath, 'wb').write(cutout_img_content)
                else:
                    resp = requests.get(url, stream=True).raw
                    img = np.asarray(bytearray(resp.read()), dtype='uint8')
                    img = cv2.imdecode(img, cv2.IMREAD_COLOR)
                    img_width = img.shape[1]
                    img_height = img.shape[0]
                    x = int(0.225 * img_width)
                    y = int(0.285 * img_height)
                    w = int(0.537 * img_width)
                    h = int(0.437 * img_height)
                    cutout_img_content = img[y:y+h, x:x+w]
                    cv2.imwrite(cutout_filepath.as_posix(), cutout_img_content)
