import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle
import pandas as pd
import numpy as np
from matplotlib import rc
#rc('font',**{'family':'sans-serif','sans-serif':['Helvetica']})
## for Palatino and other serif fonts use:
rc('font',**{'family':'serif','serif':['Palatino']})
rc('text', usetex=True)

WER_array = [['Modellname', 'Id', 'WER_A', 'WER_B'],
             ['German_Kurrent_17th-18th', 27457, 26.6, 30.3],
             ['Transkribus German handwriting M1', 35909, 21.7, 24.1],
             ['Transformer HTR T100', 44522, 8.7, 8.1],
             ['BED_TextTraining1_GKurr17-18', 49384, 19.7, 8.7],
             ['BED_TestModel1', 49357, 11.1, 4.1],
             ['BED_TestModel3', 49656, 11.8, 3.7]]
WER_df = pd.DataFrame(WER_array[1:], columns=WER_array[0])

fig, ax = plt.subplots()
ax.bar(np.arange(6), WER_df['WER_A'], width=0.3, label='$\mathrm{WER}_\mathrm{all}$')
ax.bar(np.arange(6) + 0.3, WER_df['WER_B'], width=0.3, label='$\mathrm{WER}_{\{1, 3, 4\}}$')
plt.xticks(np.arange(6) + 0.15, WER_df['Id'])
# plt.xlabel('Modell-Id')
plt.xlabel('Model ID')
plt.ylabel('WER [\%]')
# plt.title('Manuell bestimmte Wortfehlerraten auf dem Validierungs-Set')
plt.title('Manually determined word error rates on the validation set')
plt.legend(loc='upper right')

plt.savefig('../img/documentation/WER_Validation_eng.png', bbox_inches='tight', dpi=300)
# plt.show()
