import random

codices = [['codex_14.376', 451],
           ['codex_14.377', 450],
           ['codex_14.378', 565],
           ['codex_14.379', 532],
           ['codex_14.380', 490]]

print('All pages:', sum(map(lambda x: x[1], codices)))
print('Only first three volumes:', sum(map(lambda x: x[1], codices[:3])))

random.seed(42)
page_numbers = [(codex[0], sorted(random.sample(range(codex[1]), 20))) for codex in codices]
for entry in page_numbers:
    print(entry)
